/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.schedulers;

import io.reactivex.rxjava3.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class Timed<T> {
    final T value;
    final long time;
    final TimeUnit unit;

    public Timed(@NonNull T value, long time, @NonNull TimeUnit unit) {
        this.value = Objects.requireNonNull(value, "value is null");
        this.time = time;
        this.unit = Objects.requireNonNull(unit, "unit is null");
    }

    @NonNull
    public T value() {
        return this.value;
    }

    @NonNull
    public TimeUnit unit() {
        return this.unit;
    }

    public long time() {
        return this.time;
    }

    public long time(@NonNull TimeUnit unit) {
        return unit.convert(this.time, this.unit);
    }

    public boolean equals(Object other) {
        if (other instanceof Timed) {
            Timed o = (Timed)other;
            return Objects.equals(this.value, o.value) && this.time == o.time && Objects.equals((Object)this.unit, (Object)o.unit);
        }
        return false;
    }

    public int hashCode() {
        int h = this.value.hashCode();
        h = h * 31 + (int)(this.time >>> 31 ^ this.time);
        h = h * 31 + this.unit.hashCode();
        return h;
    }

    public String toString() {
        return "Timed[time=" + this.time + ", unit=" + (Object)((Object)this.unit) + ", value=" + this.value + "]";
    }
}

