/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.www.service;

import java.util.List;
import org.apache.hop.core.action.GuiContextAction;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.context.HopGuiPipelineTransformContext;
import org.apache.hop.ui.hopgui.perspective.metadata.MetadataPerspective;
import org.apache.hop.ui.www.service.WebServiceEditor;
import org.apache.hop.www.service.WebService;

@GuiPlugin
public class WebServiceGuiPlugin {
    private static final Class<?> PKG = WebServiceGuiPlugin.class;

    @GuiContextAction(id="pipeline-graph-transform-9000-add-web-serviec", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Info, name="i18n::WebserviceGuiPlugin.GuiAction.Label", tooltip="i18n::WebserviceGuiPlugin.GuiAction.ToolTip", image="ui/images/webservice.svg", category="Data routing", categoryOrder="2")
    public void addWebServiceForTransform(HopGuiPipelineTransformContext context) {
        PipelineMeta pipelineMeta = context.getPipelineMeta();
        TransformMeta transformMeta = context.getTransformMeta();
        IVariables variables = context.getPipelineGraph().getVariables();
        HopGui hopGui = HopGui.getInstance();
        try {
            IRowMeta fields = pipelineMeta.getTransformFields(variables, transformMeta);
            EnterSelectionDialog fieldSelectionDialog = new EnterSelectionDialog(hopGui.getShell(), fields.getFieldNames(), BaseMessages.getString(PKG, (String)"WebserviceGuiPlugin.GuiAction.SelectOutputField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"WebserviceGuiPlugin.GuiAction.SelectOutputField.Description", (String[])new String[0]));
            String fieldName = fieldSelectionDialog.open();
            if (fieldName == null) {
                return;
            }
            MultiMetadataProvider metadataProvider = hopGui.getMetadataProvider();
            IHopMetadataSerializer serializer = metadataProvider.getSerializer(WebService.class);
            MetadataManager<WebService> manager = new MetadataManager<WebService>(hopGui.getVariables(), (IHopMetadataProvider)metadataProvider, WebService.class, hopGui.getShell());
            WebService webService = null;
            List serviceNames = serializer.listObjectNames();
            if (serviceNames.isEmpty()) {
                MessageBox box = new MessageBox(hopGui.getShell(), 196);
                box.setText(BaseMessages.getString(PKG, (String)"WebserviceGuiPlugin.GuiAction.NoService.Label", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"WebserviceGuiPlugin.GuiAction.NoService.Description", (String[])new String[0]));
                int answer = box.open();
                if ((answer & 0x40) != 0) {
                    webService = new WebService(pipelineMeta.getName(), true, pipelineMeta.getFilename(), transformMeta.getName(), fieldName, "text/plain", null, false, null, null, null);
                    manager.newMetadata(webService);
                    return;
                }
                return;
            }
            EnterSelectionDialog dialog = new EnterSelectionDialog(hopGui.getShell(), serviceNames.toArray(new String[0]), BaseMessages.getString(PKG, (String)"WebserviceGuiPlugin.GuiAction.SelectService.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"WebserviceGuiPlugin.GuiAction.SelectService.Description", (String[])new String[0]));
            String pipelineProbeName = dialog.open();
            if (pipelineProbeName != null) {
                webService = (WebService)serializer.load(pipelineProbeName);
            }
            if (webService != null) {
                String key;
                MetadataPerspective perspective = hopGui.getPerspectiveManager().findPerspective(MetadataPerspective.class);
                WebServiceEditor editor = (WebServiceEditor)perspective.findEditor(key = WebService.class.getAnnotation(HopMetadata.class).key(), webService.getName());
                if (editor != null) {
                    webService = new WebService();
                    editor.getWidgetsContent(webService);
                    webService.setFilename(pipelineMeta.getFilename());
                    webService.setTransformName(transformMeta.getName());
                    webService.setFieldName(fieldName);
                    editor.setMetadata(webService);
                    editor.setWidgetsContent();
                    editor.setChanged();
                    perspective.activate();
                    perspective.setActiveEditor(editor);
                } else {
                    webService.setFilename(pipelineMeta.getFilename());
                    webService.setTransformName(transformMeta.getName());
                    webService.setFieldName(fieldName);
                    serializer.save((IHopMetadata)webService);
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"WebserviceGuiPlugin.GuiAction.ErrorDialog.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"WebserviceGuiPlugin.GuiAction.ErrorDialog.Description", (String[])new String[0]) + " '" + transformMeta.getName() + "'", e);
        }
    }
}

