/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.numbersystrem;

import java.util.Comparator;
import org.psjava.algo.math.numbertheory.GCD;
import org.psjava.ds.numbersystrem.AddInvert;
import org.psjava.ds.numbersystrem.DivisableNumberSystem;
import org.psjava.ds.numbersystrem.Fraction;
import org.psjava.ds.numbersystrem.IntegerDivisableNumberSystem;

public class FractionNumberSystem<T>
implements DivisableNumberSystem<Fraction<T>>,
Comparator<Fraction<T>> {
    private final IntegerDivisableNumberSystem<T> ns;

    public static <T> FractionNumberSystem<T> newInstance(IntegerDivisableNumberSystem<T> subSystem) {
        return new FractionNumberSystem<T>(subSystem);
    }

    private FractionNumberSystem(IntegerDivisableNumberSystem<T> subSystem) {
        this.ns = subSystem;
    }

    @Override
    public Fraction<T> getOne() {
        return Fraction.valueOf(this.ns.getOne(), this.ns.getOne());
    }

    @Override
    public Fraction<T> getZero() {
        return Fraction.valueOf(this.ns.getZero(), this.ns.getOne());
    }

    @Override
    public Fraction<T> getByInt(int v) {
        return Fraction.valueOf(this.ns.getByInt(v), this.ns.getOne());
    }

    @Override
    public Fraction<T> add(Fraction<T> v1, Fraction<T> v2) {
        Object num = this.ns.add(this.ns.multiply(v1.numerator, v2.denominator), this.ns.multiply(v2.numerator, v1.denominator));
        Object denom = this.ns.multiply(v1.denominator, v2.denominator);
        return this.reduce(num, denom);
    }

    @Override
    public Fraction<T> subtract(Fraction<T> minuend, Fraction<T> subtrahend) {
        Object num = this.ns.subtract(this.ns.multiply(minuend.numerator, subtrahend.denominator), this.ns.multiply(subtrahend.numerator, minuend.denominator));
        Object denom = this.ns.multiply(minuend.denominator, subtrahend.denominator);
        return this.reduce(num, denom);
    }

    @Override
    public Fraction<T> multiply(Fraction<T> v1, Fraction<T> v2) {
        Object num = this.ns.multiply(v1.numerator, v2.numerator);
        Object denom = this.ns.multiply(v1.denominator, v2.denominator);
        return this.reduce(num, denom);
    }

    @Override
    public boolean areEqual(Fraction<T> o1, Fraction<T> o2) {
        Object t1 = this.ns.multiply(o1.numerator, o2.denominator);
        Object t2 = this.ns.multiply(o2.numerator, o1.denominator);
        return this.ns.areEqual(t1, t2);
    }

    @Override
    public Fraction<T> divide(Fraction<T> dividend, Fraction<T> divisor) {
        Object num = this.ns.multiply(dividend.numerator, divisor.denominator);
        Object denom = this.ns.multiply(dividend.denominator, divisor.numerator);
        return this.reduce(num, denom);
    }

    @Override
    public int getSign(Fraction<T> v) {
        return this.ns.getSign(v.numerator) * this.ns.getSign(v.denominator);
    }

    @Override
    public boolean isNegative(Fraction<T> v) {
        return this.getSign(v) < 0;
    }

    @Override
    public boolean isOne(Fraction<T> v) {
        return this.ns.areEqual(v.numerator, v.denominator);
    }

    @Override
    public boolean isPositive(Fraction<T> v) {
        return this.getSign(v) > 0;
    }

    @Override
    public boolean isZero(Fraction<T> v) {
        return this.ns.isZero(v.numerator);
    }

    @Override
    public int compare(Fraction<T> o1, Fraction<T> o2) {
        o1 = this.reduce(o1);
        o2 = this.reduce(o2);
        Object v1 = this.ns.multiply(o1.numerator, o2.denominator);
        Object v2 = this.ns.multiply(o2.numerator, o1.denominator);
        return this.ns.compare(v1, v2);
    }

    public Fraction<T> reduce(Fraction<T> v) {
        return this.reduce(v.numerator, v.denominator);
    }

    private Fraction<T> reduce(T num, T denom) {
        if (this.ns.isNegative(denom)) {
            num = AddInvert.calc(this.ns, num);
            denom = AddInvert.calc(this.ns, denom);
        }
        T gcd = GCD.gcd(this.ns, num, denom);
        num = this.ns.integerDivide(num, gcd);
        denom = this.ns.integerDivide(denom, gcd);
        return Fraction.valueOf(num, denom);
    }
}

