/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.utils;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import org.kie.internal.utils.CompositeClassLoader;

public class ClassLoaderUtil {
    private static final ProtectionDomain PROTECTION_DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return ClassLoaderUtil.class.getProtectionDomain();
        }
    });

    public static CompositeClassLoader getClassLoader(ClassLoader[] classLoaders, Class<?> cls, boolean enableCache) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader currentClassLoader = cls != null ? cls.getClassLoader() : ClassLoaderUtil.class.getClassLoader();
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        CompositeClassLoader cl = new CompositeClassLoader();
        if (systemClassLoader != null) {
            cl.addClassLoader(systemClassLoader);
        }
        if (currentClassLoader != null) {
            cl.addClassLoader(currentClassLoader);
        }
        if (contextClassLoader != null) {
            cl.addClassLoader(contextClassLoader);
        }
        if (classLoaders != null && classLoaders.length > 0) {
            for (ClassLoader classLoader : classLoaders) {
                if (classLoader == null) continue;
                cl.addClassLoader(classLoader);
            }
        }
        cl.setCachingEnabled(enableCache);
        return cl;
    }
}

