/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.event;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.gridkit.jvmtool.event.TagCollection;

public class SimpleTagCollection
implements TagCollection {
    private SortedMap<Tag, Tag> tags = new TreeMap<Tag, Tag>();

    public SimpleTagCollection() {
    }

    public SimpleTagCollection(TagCollection that) {
        for (String key : that) {
            for (String tag : that.tagsFor(key)) {
                this.put(key, tag);
            }
        }
    }

    protected SimpleTagCollection(Iterable<Tag> tags) {
        for (Tag t : tags) {
            this.tags.put(t, t);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return new KeyIterator(this.tags.keySet().iterator());
    }

    @Override
    public Iterable<String> tagsFor(final String key) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new TagIterator(key, SimpleTagCollection.this.tags.tailMap(new Tag(key, "")).keySet().iterator());
            }
        };
    }

    @Override
    public String firstTagFor(String key) {
        SortedMap<Tag, Tag> tail = this.tags.tailMap(new Tag(key, ""));
        if (!tail.isEmpty()) {
            Tag f = tail.firstKey();
            if (key.equals(f.tagKey)) {
                return f.tagValue;
            }
        }
        return null;
    }

    @Override
    public boolean contains(String key, String tag) {
        if (key == null) {
            throw new NullPointerException("'key' is null");
        }
        if (tag == null) {
            throw new NullPointerException("'tag' is null");
        }
        return this.tags.containsKey(new Tag(key, tag));
    }

    @Override
    public SimpleTagCollection clone() {
        return new SimpleTagCollection(this.tags.keySet());
    }

    public void put(String key, String tag) {
        if (key == null) {
            throw new NullPointerException("'key' is null");
        }
        if (tag == null) {
            throw new NullPointerException("'tag' is null");
        }
        Tag t = new Tag(key, tag);
        this.tags.put(t, t);
    }

    public void putAll(TagCollection that) {
        for (String key : that) {
            for (String tag : that.tagsFor(key)) {
                this.put(key, tag);
            }
        }
    }

    public void remove(String key) {
        if (key == null) {
            throw new NullPointerException("'key' is null");
        }
        Iterator<Tag> it = this.tags.tailMap(new Tag(key, "")).keySet().iterator();
        while (it.hasNext()) {
            Tag t = it.next();
            if (!t.tagKey.equals(key)) break;
            it.remove();
        }
    }

    public void remove(String key, String tag) {
        if (key == null) {
            throw new NullPointerException("'key' is null");
        }
        if (tag == null) {
            throw new NullPointerException("'tag' is null");
        }
        Tag t = new Tag(key, tag);
        this.tags.remove(t);
    }

    public void clear() {
        this.tags.clear();
    }

    public String toString() {
        return this.tags.keySet().toString();
    }

    private static class Tag
    implements Comparable<Tag> {
        final String tagKey;
        final String tagValue;

        public Tag(String tagKey, String tagValue) {
            this.tagKey = tagKey;
            this.tagValue = tagValue;
        }

        @Override
        public int compareTo(Tag that) {
            int n = this.tagKey.compareTo(that.tagKey);
            if (n == 0) {
                n = this.tagValue.compareTo(that.tagValue);
            }
            return n;
        }

        public String toString() {
            return this.tagKey + ":" + this.tagValue;
        }
    }

    private static class TagIterator
    implements Iterator<String> {
        private final String key;
        private final Iterator<Tag> iterator;
        private String nextTag;

        public TagIterator(String key, Iterator<Tag> iterator) {
            this.key = key;
            this.iterator = iterator;
            this.seekNext();
        }

        private void seekNext() {
            if (this.iterator.hasNext()) {
                Tag tag = this.iterator.next();
                if (this.key.equals(tag.tagKey)) {
                    this.nextTag = tag.tagValue;
                    return;
                }
            }
            this.nextTag = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextTag != null;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String tag = this.nextTag;
            this.seekNext();
            return tag;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class KeyIterator
    implements Iterator<String> {
        private final Iterator<Tag> iterator;
        private String nextKey = null;

        public KeyIterator(Iterator<Tag> tags) {
            this.iterator = tags;
            this.seekNext();
        }

        private void seekNext() {
            while (this.iterator.hasNext()) {
                Tag tag = this.iterator.next();
                if (tag.tagKey.equals(this.nextKey)) continue;
                this.nextKey = tag.tagKey;
                return;
            }
            this.nextKey = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextKey != null;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String tagKey = this.nextKey;
            this.seekNext();
            return tagKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

