/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.AutoValue_Filter_Inner_FilterDescription;
import org.apache.beam.sdk.schemas.utils.RowSelector;
import org.apache.beam.sdk.schemas.utils.SelectHelpers;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Filter {
    public static <T> @UnknownKeyFor @NonNull @Initialized Inner<T> create() {
        return new Inner();
    }

    public static class Inner<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FilterDescription<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> filters = Lists.newArrayList();

        public <FieldT> @UnknownKeyFor @NonNull @Initialized Inner<T> whereFieldName(@UnknownKeyFor @NonNull @Initialized String fieldName, @UnknownKeyFor @NonNull @Initialized SerializableFunction<FieldT, @UnknownKeyFor @NonNull @Initialized Boolean> predicate) {
            this.filters.add(new AutoValue_Filter_Inner_FilterDescription.Builder().setFieldAccessDescriptor(FieldAccessDescriptor.withFieldNames(fieldName)).setPredicate(predicate).setSelectsSingleField(true).build());
            return this;
        }

        public <FieldT> @UnknownKeyFor @NonNull @Initialized Inner<T> whereFieldId(@UnknownKeyFor @NonNull @Initialized int fieldId, @UnknownKeyFor @NonNull @Initialized SerializableFunction<FieldT, @UnknownKeyFor @NonNull @Initialized Boolean> predicate) {
            this.filters.add(new AutoValue_Filter_Inner_FilterDescription.Builder().setFieldAccessDescriptor(FieldAccessDescriptor.withFieldIds(fieldId)).setPredicate(predicate).setSelectsSingleField(true).build());
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Inner<T> whereFieldNames(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fieldNames, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Boolean> predicate) {
            this.filters.add(new AutoValue_Filter_Inner_FilterDescription.Builder().setFieldAccessDescriptor(FieldAccessDescriptor.withFieldNames(fieldNames)).setPredicate(predicate).setSelectsSingleField(false).build());
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized Inner<T> whereFieldIds(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> fieldIds, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Boolean> predicate) {
            this.filters.add(new AutoValue_Filter_Inner_FilterDescription.Builder().setFieldAccessDescriptor(FieldAccessDescriptor.withFieldIds(fieldIds)).setPredicate(predicate).setSelectsSingleField(false).build());
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            Schema inputSchema = input.getSchema();
            final List resolvedFilters = this.filters.stream().map(f -> f.toBuilder().setFieldAccessDescriptor(f.getFieldAccessDescriptor().resolve(inputSchema)).build()).map(f -> f.toBuilder().setInputSchema(inputSchema).setSelectedSchema(SelectHelpers.getOutputSchema(inputSchema, f.getFieldAccessDescriptor())).build()).collect(Collectors.toList());
            return (PCollection)input.apply(ParDo.of(new DoFn<T, T>(){

                @DoFn.ProcessElement
                public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row row, @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> o) {
                    for (FilterDescription filter : resolvedFilters) {
                        SerializableFunction predicate;
                        Row selected = filter.getRowSelector().select(row);
                        if (!(filter.getSelectsSingleField() ? (predicate = filter.getPredicate()).apply(selected.getValue(0)) == false : (predicate = filter.getPredicate()).apply(selected) == false)) continue;
                        return;
                    }
                    o.output(row);
                }
            }));
        }

        @AutoValue
        static abstract class FilterDescription<@UnknownKeyFor FieldT>
        implements Serializable {
            private transient @UnknownKeyFor @NonNull @Initialized RowSelector rowSelector;

            FilterDescription() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor getFieldAccessDescriptor();

            abstract @UnknownKeyFor @NonNull @Initialized SerializableFunction<FieldT, @UnknownKeyFor @NonNull @Initialized Boolean> getPredicate();

            abstract @Nullable @UnknownKeyFor @Initialized Schema getSelectedSchema();

            abstract @UnknownKeyFor @NonNull @Initialized boolean getSelectsSingleField();

            abstract @Nullable @UnknownKeyFor @Initialized Schema getInputSchema();

            abstract @UnknownKeyFor @NonNull @Initialized Builder<FieldT> toBuilder();

            public @UnknownKeyFor @NonNull @Initialized RowSelector getRowSelector() {
                if (this.rowSelector == null) {
                    this.rowSelector = SelectHelpers.getRowSelectorOptimized(this.getInputSchema(), this.getFieldAccessDescriptor());
                }
                return this.rowSelector;
            }

            @AutoValue.Builder
            static abstract class Builder<@UnknownKeyFor FieldT> {
                Builder() {
                }

                abstract @UnknownKeyFor @NonNull @Initialized Builder<FieldT> setFieldAccessDescriptor(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor var1);

                abstract @UnknownKeyFor @NonNull @Initialized Builder<FieldT> setPredicate(@UnknownKeyFor @NonNull @Initialized SerializableFunction<FieldT, @UnknownKeyFor @NonNull @Initialized Boolean> var1);

                abstract @UnknownKeyFor @NonNull @Initialized Builder<FieldT> setSelectedSchema(@Nullable @UnknownKeyFor @Initialized Schema var1);

                abstract @UnknownKeyFor @NonNull @Initialized Builder<FieldT> setSelectsSingleField(@UnknownKeyFor @NonNull @Initialized boolean var1);

                abstract @UnknownKeyFor @NonNull @Initialized Builder<FieldT> setInputSchema(@Nullable @UnknownKeyFor @Initialized Schema var1);

                abstract @UnknownKeyFor @NonNull @Initialized FilterDescription<FieldT> build();
            }
        }
    }
}

