/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.randomvalue;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNone;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IEnumHasCode;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.randomvalue.RandomValue;
import org.apache.hop.pipeline.transforms.randomvalue.RandomValueData;

@Transform(id="RandomValue", image="randomvalue.svg", name="i18n::RandomValue.Name", description="i18n::RandomValue.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::RandomValueMeta.keyword"}, documentationUrl="/pipeline/transforms/generaterandomvalue.html")
public class RandomValueMeta
extends BaseTransformMeta<RandomValue, RandomValueData> {
    private static final Class<?> PKG = RandomValueMeta.class;
    @HopMetadataProperty(key="seed")
    private String seed;
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<RVField> fields = new ArrayList<RVField>();

    public RandomValueMeta() {
    }

    public RandomValueMeta(RandomValueMeta m) {
        this();
        this.seed = m.seed;
        m.fields.forEach(f -> this.fields.add(new RVField((RVField)f)));
    }

    public RandomValueMeta clone() {
        return new RandomValueMeta(this);
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        for (RVField field : this.fields) {
            ValueMetaNumber v = switch (field.getType()) {
                case RandomType.NUMBER -> new ValueMetaNumber(field.getName(), 10, 5);
                case RandomType.INTEGER -> new ValueMetaInteger(field.getName(), 10, 0);
                case RandomType.STRING -> new ValueMetaString(field.getName(), 13, 0);
                case RandomType.UUID, RandomType.UUID4 -> new ValueMetaString(field.getName(), 36, 0);
                case RandomType.HMAC_MD5, RandomType.HMAC_SHA1, RandomType.HMAC_SHA256, RandomType.HMAC_SHA512, RandomType.HMAC_SHA384 -> new ValueMetaString(field.getName(), 100, 0);
                default -> new ValueMetaNone(field.getName());
            };
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        int nrRemarks = remarks.size();
        for (RVField field : this.fields) {
            if (field.getType() != null && field.getType() != RandomType.NONE) continue;
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RandomValueMeta.CheckResult.FieldHasNoType", (String[])new String[]{field.getName()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (remarks.size() == nrRemarks) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RandomValueMeta.CheckResult.AllTypesSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    @Generated
    public String getSeed() {
        return this.seed;
    }

    @Generated
    public List<RVField> getFields() {
        return this.fields;
    }

    @Generated
    public void setSeed(String seed) {
        this.seed = seed;
    }

    @Generated
    public void setFields(List<RVField> fields) {
        this.fields = fields;
    }

    public static final class RVField {
        @HopMetadataProperty(key="name")
        private String name;
        @HopMetadataProperty(key="type", storeWithCode=true)
        private RandomType type = RandomType.NONE;

        public RVField() {
        }

        public RVField(RVField f) {
            this();
            this.name = f.name;
            this.type = f.type;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public RandomType getType() {
            return this.type;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setType(RandomType type) {
            this.type = type;
        }
    }

    public static enum RandomType implements IEnumHasCodeAndDescription
    {
        NONE("", ""),
        NUMBER("random number", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomNumber", (String[])new String[0])),
        INTEGER("random integer", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomInteger", (String[])new String[0])),
        STRING("random string", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomString", (String[])new String[0])),
        UUID("random uuid", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomUUID", (String[])new String[0])),
        UUID4("random uuid4", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomUUID4", (String[])new String[0])),
        HMAC_MD5("random machmacmd5", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomHMACMD5", (String[])new String[0])),
        HMAC_SHA1("random machmacsha1", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomHMACSHA1", (String[])new String[0])),
        HMAC_SHA256("random machmacsha256", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomHMACSHA256", (String[])new String[0])),
        HMAC_SHA512("random machmacsha512", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomHMACSHA512", (String[])new String[0])),
        HMAC_SHA384("random machmacsha384", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomHMACSHA384", (String[])new String[0]));

        private final String code;
        private final String description;

        private RandomType(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public static String[] getDescriptions() {
            return IEnumHasCodeAndDescription.getDescriptions(RandomType.class);
        }

        public static RandomType lookupDescription(String description) {
            return (RandomType)IEnumHasCodeAndDescription.lookupDescription(RandomType.class, (String)description, (IEnumHasCodeAndDescription)NONE);
        }

        public static RandomType lookupCode(String code) {
            return (RandomType)IEnumHasCode.lookupCode(RandomType.class, (String)code, (IEnumHasCode)NONE);
        }

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }
    }
}

