/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.types;

import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.jdbc.internal.ExceptionUtils;
import com.clickhouse.jdbc.internal.JdbcUtils;
import com.clickhouse.jdbc.types.ArrayResultSet;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Array
implements java.sql.Array {
    private static final Logger log = LoggerFactory.getLogger(Array.class);
    private final ClickHouseColumn column;
    private Object[] array;
    private final int type;
    private final String elementTypeName;
    private boolean valid;
    private final ClickHouseDataType baseDataType;
    private ArrayResultSet arrayResultSet;

    public Array(ClickHouseColumn column, Object[] elements) throws SQLException {
        this.column = column;
        this.array = elements;
        ClickHouseColumn baseColumn = this.column.isArray() ? this.column.getArrayBaseColumn() : this.column;
        this.baseDataType = baseColumn.getDataType();
        this.elementTypeName = baseColumn.getOriginalTypeName();
        this.type = JdbcUtils.CLICKHOUSE_TO_SQL_TYPE_MAP.getOrDefault(this.baseDataType, JDBCType.OTHER).getVendorTypeNumber();
        this.valid = true;
    }

    public ClickHouseDataType getBaseDataType() {
        return this.baseDataType;
    }

    public int getNestedLevel() {
        return this.column.getArrayNestedLevel();
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        this.ensureValid();
        return this.elementTypeName;
    }

    @Override
    public int getBaseType() throws SQLException {
        this.ensureValid();
        return this.type;
    }

    @Override
    public Object getArray() throws SQLException {
        this.ensureValid();
        return this.array;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getArray(Map<String, Class<?>>) is not supported", "0A000");
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        this.ensureValid();
        if (index < 0L) {
            throw new SQLException("Index cannot be negative");
        }
        if (count < 0) {
            throw new SQLException("Count cannot be negative");
        }
        if (this.array == null || (long)count > (long)this.array.length - index) {
            throw new SQLException("Not enough elements after index " + index);
        }
        Object[] smallerArray = new Object[count];
        System.arraycopy(this.array, (int)index, smallerArray, 0, count);
        return smallerArray;
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getArray(long, int, Map<String, Class<?>>) is not supported", "0A000");
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        this.ensureValid();
        if (this.arrayResultSet == null) {
            this.arrayResultSet = new ArrayResultSet(this.array, this.column);
        }
        return this.arrayResultSet;
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getResultSet(Map<String, Class<?>>) is not supported", "0A000");
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        this.ensureValid();
        return new ArrayResultSet(this.getArray(index, count), this.column);
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getResultSet(long, int, Map<String, Class<?>>) is not supported", "0A000");
    }

    @Override
    public void free() throws SQLException {
        this.valid = false;
        this.array = null;
    }

    private void ensureValid() throws SQLException {
        if (!this.valid) {
            throw ExceptionUtils.toSqlState(new SQLFeatureNotSupportedException("Array is not valid. Possible free() was called."));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Array other = (Array)obj;
        return this.type == other.type && Arrays.equals(this.array, other.array);
    }
}

