/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Locale;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;

@Description(name="printf", value="_FUNC_(String format, Obj... args) - function that can format strings according to printf-style format strings", extended="Example:\n  > SELECT _FUNC_(\"Hello World %d %s\", 100, \"days\")FROM src LIMIT 1;\n  \"Hello World 100 days\"")
public class GenericUDFPrintf
extends GenericUDF {
    private transient ObjectInspector[] argumentOIs;
    protected transient ObjectInspectorConverters.Converter converterFormat;
    private final Text resultText = new Text();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 1) {
            throw new UDFArgumentLengthException("The function PRINTF(String format, Obj... args) needs at least one arguments.");
        }
        WritableStringObjectInspector resultOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        if (arguments[0].getCategory() == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveObjectInspector poi = (PrimitiveObjectInspector)arguments[0];
            if (poi.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING && poi.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.CHAR && poi.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.VARCHAR && poi.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.VOID) {
                throw new UDFArgumentTypeException(0, "Argument 1 of function PRINTF must be \"string\", but \"" + arguments[0].getTypeName() + "\" was found.");
            }
        } else {
            throw new UDFArgumentTypeException(0, "Argument 1 of function PRINTF must be \"string\", but \"" + arguments[0].getTypeName() + "\" was found.");
        }
        this.converterFormat = ObjectInspectorConverters.getConverter((ObjectInspector)arguments[0], (ObjectInspector)resultOI);
        for (int i = 1; i < arguments.length; ++i) {
            if (arguments[i].getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE)) continue;
            throw new UDFArgumentTypeException(i, "Argument " + (i + 1) + " of function PRINTF must be \"" + String.valueOf(ObjectInspector.Category.PRIMITIVE) + "\", but \"" + arguments[i].getTypeName() + "\" was found.");
        }
        this.argumentOIs = arguments;
        return resultOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0].get() == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        Text pattern = (Text)this.converterFormat.convert(arguments[0].get());
        ArrayList<Object> argumentList = new ArrayList<Object>();
        block4: for (int i = 1; i < arguments.length; ++i) {
            PrimitiveObjectInspector poi = (PrimitiveObjectInspector)this.argumentOIs[i];
            switch (poi.getPrimitiveCategory()) {
                case BOOLEAN: 
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case CHAR: 
                case VARCHAR: 
                case STRING: 
                case TIMESTAMP: {
                    argumentList.add(poi.getPrimitiveJavaObject(arguments[i].get()));
                    continue block4;
                }
                case DECIMAL: {
                    Object obj = poi.getPrimitiveJavaObject(arguments[i].get());
                    if (obj instanceof HiveDecimal) {
                        obj = ((HiveDecimal)obj).doubleValue();
                    } else if (obj instanceof BigDecimal) {
                        obj = ((BigDecimal)obj).doubleValue();
                    }
                    argumentList.add(obj);
                    continue block4;
                }
                default: {
                    argumentList.add(arguments[i].get());
                }
            }
        }
        formatter.format(pattern.toString(), argumentList.toArray());
        this.resultText.set(sb.toString());
        formatter.close();
        return this.resultText;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length >= 2);
        return this.getStandardDisplayString("printf", children);
    }
}

