/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import org.apache.hadoop.hive.common.MemoryEstimate;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashKeyRef;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.serde2.WriteBuffers;

public class VectorMapJoinFastBytesHashMapStore
implements MemoryEstimate {
    private WriteBuffers writeBuffers;

    public WriteBuffers getWriteBuffers() {
        return this.writeBuffers;
    }

    public long addFirst(long partialHashCode, byte[] keyBytes, int keyStart, int keyLength, byte[] valueBytes, int valueStart, int valueLength) {
        boolean isKeyLengthBig;
        this.writeBuffers.write(RelativeOffset.zeroPadding);
        long absoluteOffset = this.writeBuffers.getWritePoint();
        boolean bl = isKeyLengthBig = keyLength >= 255;
        if (isKeyLengthBig) {
            this.writeBuffers.writeVInt(keyLength);
        }
        this.writeBuffers.write(keyBytes, keyStart, keyLength);
        this.writeBuffers.writeVInt(valueLength);
        this.writeBuffers.write(valueBytes, valueStart, valueLength);
        long refWord = partialHashCode;
        refWord |= absoluteOffset << 15;
        refWord = isKeyLengthBig ? (refWord |= 0x3FC0000000000000L) : (refWord |= (long)keyLength << 54);
        return refWord |= 0x4000000000000000L;
    }

    public long addMore(long refWord, byte[] valueBytes, int valueStart, int valueLength, WriteBuffers.Position unsafeReadPos) {
        long referenceAbsoluteOffset = VectorMapJoinFastBytesHashKeyRef.KeyRef.getAbsoluteOffset(refWord) - 5L;
        long nextAbsoluteValueOffset = this.writeBuffers.getWritePoint();
        if (VectorMapJoinFastBytesHashKeyRef.KeyRef.getIsSingleFlag(refWord)) {
            refWord &= 0xBFFFFFFFFFFFFFFFL;
            this.writeBuffers.write(RelativeOffset.zeroPadding);
        } else {
            long oldPrevRelativeValueOffset = this.writeBuffers.readNByteLong(referenceAbsoluteOffset, 5, unsafeReadPos);
            long prevAbsoluteValueOffset = referenceAbsoluteOffset + oldPrevRelativeValueOffset;
            long newPrevRelativeValueOffset = nextAbsoluteValueOffset - prevAbsoluteValueOffset;
            this.writeBuffers.writeFiveByteULong(newPrevRelativeValueOffset);
        }
        this.writeBuffers.writeVInt(valueLength);
        this.writeBuffers.write(valueBytes, valueStart, valueLength);
        long newRelativeOffset = nextAbsoluteValueOffset - referenceAbsoluteOffset;
        this.writeBuffers.writeFiveByteULong(referenceAbsoluteOffset, newRelativeOffset);
        return refWord;
    }

    public void getKey(long refWord, WriteBuffers.ByteSegmentRef keyByteSegmentRef, WriteBuffers.Position readPos) {
        boolean isKeyLengthSmall;
        long absoluteOffset = VectorMapJoinFastBytesHashKeyRef.KeyRef.getAbsoluteOffset(refWord);
        this.writeBuffers.setReadPoint(absoluteOffset, readPos);
        int keyLength = VectorMapJoinFastBytesHashKeyRef.KeyRef.getSmallKeyLength(refWord);
        boolean bl = isKeyLengthSmall = keyLength != 255;
        if (!isKeyLengthSmall) {
            keyLength = this.writeBuffers.readVInt(readPos);
        }
        this.writeBuffers.getByteSegmentRefToCurrent(keyByteSegmentRef, keyLength, readPos);
    }

    public VectorMapJoinFastBytesHashMapStore(int writeBuffersSize) {
        this.writeBuffers = new WriteBuffers(writeBuffersSize, 0x2000000000L);
    }

    public long getEstimatedMemorySize() {
        long size = 0L;
        return size += this.writeBuffers == null ? 0L : this.writeBuffers.getEstimatedMemorySize();
    }

    private static final class RelativeOffset {
        private static final int byteLength = 5;
        private static final byte[] zeroPadding = new byte[]{0, 0, 0, 0, 0};

        private RelativeOffset() {
        }
    }

    public static class HashMapResult
    extends VectorMapJoinHashMapResult {
        private VectorMapJoinFastBytesHashMapStore hashMapStore;
        private int keyLength;
        private boolean hasRows = false;
        private long refWord = -1L;
        private boolean isSingleRow;
        private long absoluteOffset;
        private long keyAbsoluteOffset;
        private long firstValueAbsoluteOffset;
        private int readIndex;
        private boolean isNextEof;
        long nextAbsoluteValueOffset;
        private WriteBuffers.ByteSegmentRef byteSegmentRef = new WriteBuffers.ByteSegmentRef();
        private WriteBuffers.Position readPos = new WriteBuffers.Position();

        public void setKey(VectorMapJoinFastBytesHashMapStore hashMapStore, long refWord) {
            boolean isKeyLengthSmall;
            this.hashMapStore = hashMapStore;
            this.refWord = refWord;
            this.absoluteOffset = VectorMapJoinFastBytesHashKeyRef.KeyRef.getAbsoluteOffset(refWord);
            hashMapStore.writeBuffers.setReadPoint(this.absoluteOffset, this.readPos);
            this.keyLength = VectorMapJoinFastBytesHashKeyRef.KeyRef.getSmallKeyLength(refWord);
            boolean bl = isKeyLengthSmall = this.keyLength != 255;
            if (isKeyLengthSmall) {
                this.keyAbsoluteOffset = this.absoluteOffset;
            } else {
                this.keyLength = hashMapStore.writeBuffers.readVInt(this.readPos);
                this.keyAbsoluteOffset = hashMapStore.writeBuffers.getReadPoint(this.readPos);
            }
        }

        public boolean equalKey(byte[] keyBytes, int keyStart, int keyLength) {
            if (this.keyLength != keyLength) {
                return false;
            }
            return this.hashMapStore.writeBuffers.isEqual(keyBytes, keyStart, this.readPos, keyLength);
        }

        public void setMatch() {
            this.hasRows = true;
            this.isSingleRow = VectorMapJoinFastBytesHashKeyRef.KeyRef.getIsSingleFlag(this.refWord);
            this.hashMapStore.writeBuffers.setReadPoint(this.keyAbsoluteOffset + (long)this.keyLength, this.readPos);
            this.firstValueAbsoluteOffset = this.hashMapStore.writeBuffers.getReadPoint(this.readPos);
            this.readIndex = 0;
            this.isNextEof = false;
            this.setJoinResult(JoinUtil.JoinResult.MATCH);
        }

        public void set(VectorMapJoinFastBytesHashMapStore hashMapStore, long refWord) {
            this.setKey(hashMapStore, refWord);
            this.setMatch();
        }

        @Override
        public boolean hasRows() {
            return this.hasRows;
        }

        @Override
        public boolean isSingleRow() {
            if (!this.hasRows) {
                return false;
            }
            return this.isSingleRow;
        }

        @Override
        public boolean isCappedCountAvailable() {
            return true;
        }

        @Override
        public int cappedCount() {
            return this.hasRows ? (this.isSingleRow ? 1 : 2) : 0;
        }

        @Override
        public WriteBuffers.ByteSegmentRef first() {
            if (!this.hasRows) {
                return null;
            }
            this.readIndex = 0;
            this.isNextEof = false;
            return this.internalRead();
        }

        @Override
        public WriteBuffers.ByteSegmentRef next() {
            if (!this.hasRows || this.isNextEof) {
                return null;
            }
            return this.internalRead();
        }

        public WriteBuffers.ByteSegmentRef internalRead() {
            int nextValueLength;
            if (this.readIndex == 0) {
                if (this.isSingleRow) {
                    this.isNextEof = true;
                    this.nextAbsoluteValueOffset = -1L;
                } else {
                    long referenceAbsoluteOffset = this.absoluteOffset - 5L;
                    this.hashMapStore.writeBuffers.setReadPoint(referenceAbsoluteOffset, this.readPos);
                    long relativeNextValueOffset = this.hashMapStore.writeBuffers.readNByteLong(5, this.readPos);
                    this.isNextEof = false;
                    this.nextAbsoluteValueOffset = referenceAbsoluteOffset + relativeNextValueOffset;
                }
                this.hashMapStore.writeBuffers.setReadPoint(this.firstValueAbsoluteOffset, this.readPos);
                nextValueLength = this.hashMapStore.writeBuffers.readVInt(this.readPos);
            } else {
                this.hashMapStore.writeBuffers.setReadPoint(this.nextAbsoluteValueOffset, this.readPos);
                long relativeNextValueOffset = this.hashMapStore.writeBuffers.readNByteLong(5, this.readPos);
                if (relativeNextValueOffset == 0L) {
                    this.isNextEof = true;
                    this.nextAbsoluteValueOffset = -1L;
                } else {
                    this.isNextEof = false;
                    this.nextAbsoluteValueOffset -= relativeNextValueOffset;
                }
                nextValueLength = this.hashMapStore.writeBuffers.readVInt(this.readPos);
            }
            this.hashMapStore.writeBuffers.getByteSegmentRefToCurrent(this.byteSegmentRef, nextValueLength, this.readPos);
            ++this.readIndex;
            return this.byteSegmentRef;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(" + super.toString() + ", ");
            sb.append("cappedCount " + this.cappedCount() + ")");
            return sb.toString();
        }

        @Override
        public String getDetailedHashMapResultPositionString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Read index ");
            sb.append(this.readIndex);
            if (this.isSingleRow) {
                sb.append(" single row");
            } else {
                sb.append(" multiple rows ");
            }
            if (this.readIndex > 0) {
                sb.append(" byteSegmentRef is byte[] of length ");
                sb.append(this.byteSegmentRef.getBytes().length);
                sb.append(" at offset ");
                sb.append(this.byteSegmentRef.getOffset());
                sb.append(" for length ");
                sb.append(this.byteSegmentRef.getLength());
                if (!this.isSingleRow) {
                    sb.append(" (isNextEof ");
                    sb.append(this.isNextEof);
                    sb.append(" nextAbsoluteValueOffset ");
                    sb.append(this.nextAbsoluteValueOffset);
                    sb.append(")");
                }
            }
            return sb.toString();
        }
    }
}

