/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.convert;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableAnalyzer;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.convert.AlterTableConvertDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AlterTableConvertSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={872})
public class AlterTableConvertAnalyzer
extends AbstractAlterTableAnalyzer {
    public AlterTableConvertAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected void analyzeCommand(TableName tableName, Map<String, String> partitionSpec, ASTNode command) throws SemanticException {
        Table table = this.getTable(tableName);
        this.validateAlterTableType(table, AlterTableType.ADDPROPS, false);
        this.inputs.add(new ReadEntity(table));
        ASTNode targetType = (ASTNode)command.getChild(0);
        Map<String, String> properties = new HashMap<String, String>();
        if (command.getChildCount() == 2) {
            properties = AlterTableConvertAnalyzer.getProps((ASTNode)command.getChild(1).getChild(0));
        }
        AlterTableConvertSpec spec = new AlterTableConvertSpec(targetType.getText(), properties);
        AlterTableConvertDesc desc = new AlterTableConvertDesc(tableName, spec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }
}

