/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.show;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.formatting.MapBuilder;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;

abstract class ShowDatabasesFormatter {
    ShowDatabasesFormatter() {
    }

    static ShowDatabasesFormatter getFormatter(HiveConf conf) {
        if (MetaDataFormatUtils.isJson(conf)) {
            return new JsonShowDatabasesFormatter();
        }
        return new TextShowDatabasesFormatter();
    }

    abstract void showDatabases(DataOutputStream var1, List<String> var2) throws HiveException;

    static class JsonShowDatabasesFormatter
    extends ShowDatabasesFormatter {
        JsonShowDatabasesFormatter() {
        }

        @Override
        void showDatabases(DataOutputStream out, List<String> databases) throws HiveException {
            ShowUtils.asJson(out, MapBuilder.create().put("databases", databases).build());
        }
    }

    static class TextShowDatabasesFormatter
    extends ShowDatabasesFormatter {
        TextShowDatabasesFormatter() {
        }

        @Override
        void showDatabases(DataOutputStream out, List<String> databases) throws HiveException {
            try {
                for (String database : databases) {
                    out.write(database.getBytes(StandardCharsets.UTF_8));
                    out.write(10);
                }
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
        }
    }
}

