/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.retry.backoff;

import com.huaweicloud.sdk.core.retry.RetryContext;
import com.huaweicloud.sdk.core.retry.backoff.BackoffStrategy;
import com.huaweicloud.sdk.core.utils.RandomUtils;
import com.huaweicloud.sdk.core.utils.ValidationUtils;
import java.security.SecureRandom;

public class SdkBackoffStrategy
implements BackoffStrategy {
    public static final int MAX_RETRY_TIMES = 30;
    public static final int BASE_DELAY = 5;
    public static final int MAX_BACKOFF_IN_MILLISECOND = 60000;
    public static final int MIN_THROTTLE_DELAY = 300;
    public static final int MIN_RETRY_DELAY = 60;
    public static final int BASE_OF_EXPONENT = 2;
    private final ThrottlingBackoffStrategy throttlingBackoffStrategy;
    private final NonThrottlingBackoffStrategy nonThrottlingBackoffStrategy;

    private SdkBackoffStrategy() {
        this.throttlingBackoffStrategy = new ThrottlingBackoffStrategy();
        this.nonThrottlingBackoffStrategy = new NonThrottlingBackoffStrategy();
    }

    public SdkBackoffStrategy(int baseDelay, int maxBackoffInMillisecond) {
        this.throttlingBackoffStrategy = new ThrottlingBackoffStrategy(baseDelay, maxBackoffInMillisecond);
        this.nonThrottlingBackoffStrategy = new NonThrottlingBackoffStrategy(baseDelay, maxBackoffInMillisecond);
    }

    public static SdkBackoffStrategy getDefaultBackoffStrategy() {
        return new SdkBackoffStrategy();
    }

    private <ResT> boolean isThrottleException(RetryContext<ResT> context) {
        return context.getStatusCode() == 429;
    }

    @Override
    public <ResT> long computeDelayBeforeNextRetry(RetryContext<ResT> context) {
        if (this.isThrottleException(context)) {
            return this.throttlingBackoffStrategy.computeDelayBeforeNextRetry(context);
        }
        return this.nonThrottlingBackoffStrategy.computeDelayBeforeNextRetry(context);
    }

    private static int calculateExponentialDelay(int retriesAttempted, int baseDelay, int maxBackoffTime) {
        int retries = Math.min(retriesAttempted, 30);
        return (int)Math.min(Math.pow(2.0, retries) * (double)baseDelay, (double)maxBackoffTime);
    }

    public static class NonThrottlingBackoffStrategy
    implements BackoffStrategy {
        private final int baseDelay;
        private final int maxBackoffTime;
        private final SecureRandom random = RandomUtils.getDefaultSecureRandom();

        public NonThrottlingBackoffStrategy() {
            this.baseDelay = 5;
            this.maxBackoffTime = 60000;
        }

        public NonThrottlingBackoffStrategy(int baseDelay, int maxBackoffTime) {
            this.baseDelay = ValidationUtils.assertIntIsPositive(baseDelay, "baseDelay");
            this.maxBackoffTime = ValidationUtils.assertIntIsPositive(maxBackoffTime, "maxBackoffTime");
        }

        @Override
        public <ResT> long computeDelayBeforeNextRetry(RetryContext<ResT> context) {
            int expo = SdkBackoffStrategy.calculateExponentialDelay(context.getRetriesAttempted(), this.baseDelay, this.maxBackoffTime);
            return 60 + this.random.nextInt(expo);
        }
    }

    public static class ThrottlingBackoffStrategy
    implements BackoffStrategy {
        private final int baseDelay;
        private final int maxBackoffTime;
        private final SecureRandom random = RandomUtils.getDefaultSecureRandom();

        public ThrottlingBackoffStrategy() {
            this.baseDelay = 5;
            this.maxBackoffTime = 60000;
        }

        public ThrottlingBackoffStrategy(int baseDelay, int maxBackoffTime) {
            this.baseDelay = ValidationUtils.assertIntIsPositive(baseDelay, "baseDelay");
            this.maxBackoffTime = ValidationUtils.assertIntIsPositive(maxBackoffTime, "maxBackoffTime");
        }

        @Override
        public <ResT> long computeDelayBeforeNextRetry(RetryContext<ResT> context) {
            int expo = SdkBackoffStrategy.calculateExponentialDelay(context.getRetriesAttempted(), this.baseDelay, this.maxBackoffTime);
            return 300 + expo / 2 + this.random.nextInt(expo / 2 + 1);
        }
    }
}

