/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.service.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hertzbeat.common.entity.arrow.RowWrapper;
import org.apache.hertzbeat.common.entity.dto.Field;
import org.apache.hertzbeat.common.entity.dto.MetricsData;
import org.apache.hertzbeat.common.entity.dto.MetricsHistoryData;
import org.apache.hertzbeat.common.entity.dto.Value;
import org.apache.hertzbeat.common.entity.dto.ValueRow;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.support.exception.CommonException;
import org.apache.hertzbeat.warehouse.service.MetricsDataService;
import org.apache.hertzbeat.warehouse.store.history.tsdb.HistoryDataReader;
import org.apache.hertzbeat.warehouse.store.realtime.RealTimeDataReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MetricsDataServiceImpl
implements MetricsDataService {
    private static final Logger log = LoggerFactory.getLogger(MetricsDataServiceImpl.class);
    private final RealTimeDataReader realTimeDataReader;
    private final Optional<HistoryDataReader> historyDataReader;

    public MetricsDataServiceImpl(RealTimeDataReader realTimeDataReader, Optional<HistoryDataReader> historyDataReader) {
        this.realTimeDataReader = realTimeDataReader;
        this.historyDataReader = historyDataReader;
    }

    @Override
    public Boolean getWarehouseStorageServerStatus() {
        return this.historyDataReader.isPresent() && this.historyDataReader.get().isServerAvailable();
    }

    @Override
    public MetricsData getMetricsData(Long monitorId, String metrics) {
        boolean available = this.realTimeDataReader.isServerAvailable();
        if (!available) {
            throw new CommonException("real time store not available");
        }
        CollectRep.MetricsData storageData = this.realTimeDataReader.getCurrentMetricsData(monitorId, metrics);
        if (storageData == null) {
            return null;
        }
        MetricsData.MetricsDataBuilder dataBuilder = MetricsData.builder();
        dataBuilder.id(Long.valueOf(storageData.getId())).app(storageData.getApp()).metrics(storageData.getMetrics()).time(Long.valueOf(storageData.getTime()));
        dataBuilder.fields(storageData.getFields().stream().map(field -> Field.builder().name(field.getName()).type(Byte.valueOf((byte)field.getType())).label(Boolean.valueOf(field.getLabel())).unit(field.getUnit()).build()).toList());
        ArrayList<ValueRow> valueRows = new ArrayList<ValueRow>();
        if (storageData.rowCount() > 0L) {
            RowWrapper rowWrapper = storageData.readRow();
            while (rowWrapper.hasNextRow()) {
                rowWrapper = rowWrapper.nextRow();
                HashMap labels = Maps.newHashMapWithExpectedSize((int)8);
                ArrayList values = new ArrayList();
                rowWrapper.cellStream().forEach(cell -> {
                    String origin = cell.getValue();
                    if ("&nbsp;".equals(origin)) {
                        values.add(new Value());
                    } else {
                        values.add(new Value(origin));
                        if (cell.getMetadataAsBoolean("label").booleanValue()) {
                            labels.put(cell.getField().getName(), origin);
                        }
                    }
                });
                valueRows.add(ValueRow.builder().labels((Map)labels).values(values).build());
            }
            dataBuilder.valueRows(valueRows);
        }
        return dataBuilder.build();
    }

    @Override
    public MetricsHistoryData getMetricHistoryData(String instance, String app, String metrics, String metric, String history, Boolean interval) {
        Map<String, List<Value>> instanceValuesMap;
        if (history == null) {
            history = "6h";
        }
        if ((instanceValuesMap = interval == null || interval == false ? this.historyDataReader.get().getHistoryMetricData(instance, app, metrics, metric, history) : this.historyDataReader.get().getHistoryIntervalMetricData(instance, app, metrics, metric, history)).containsKey("{}")) {
            instanceValuesMap.put("", instanceValuesMap.get("{}"));
            instanceValuesMap.remove("{}");
        }
        return MetricsHistoryData.builder().instance(instance).metrics(metrics).values(instanceValuesMap).field(Field.builder().name(metric).type(Byte.valueOf((byte)0)).build()).build();
    }
}

