/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractCharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class CharSequenceLongHashMap
extends AbstractCharSequenceHashSet {
    public static final long NO_ENTRY_VALUE = -1L;
    private final ObjList<CharSequence> list;
    private final long noEntryValue;
    private long[] values;

    public CharSequenceLongHashMap() {
        this(8);
    }

    public CharSequenceLongHashMap(int initialCapacity) {
        this(initialCapacity, 0.5, -1L);
    }

    public CharSequenceLongHashMap(int initialCapacity, double loadFactor, long noEntryValue) {
        super(initialCapacity, loadFactor);
        this.noEntryValue = noEntryValue;
        this.list = new ObjList(this.capacity);
        this.values = new long[this.keys.length];
        this.clear();
    }

    @Override
    public final void clear() {
        super.clear();
        this.list.clear();
        Arrays.fill(this.values, this.noEntryValue);
    }

    public long get(@NotNull CharSequence key) {
        return this.valueAt(this.keyIndex(key));
    }

    public void increment(@NotNull CharSequence key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            this.values[-index - 1] = this.values[-index - 1] + 1L;
        } else {
            this.putAt0(index, Chars.toString(key), 0L);
        }
    }

    public ObjList<CharSequence> keys() {
        return this.list;
    }

    public boolean put(@NotNull CharSequence key, long value) {
        return this.putAt(this.keyIndex(key), key, value);
    }

    public void putAll(@NotNull CharSequenceLongHashMap other) {
        CharSequence[] otherKeys = other.keys;
        long[] otherValues = other.values;
        int n = otherKeys.length;
        for (int i = 0; i < n; ++i) {
            if (otherKeys[i] == noEntryKey) continue;
            this.put(otherKeys[i], otherValues[i]);
        }
    }

    public boolean putAt(int index, @NotNull CharSequence key, long value) {
        if (index < 0) {
            this.values[-index - 1] = value;
            return false;
        }
        String keyString = Chars.toString(key);
        this.putAt0(index, keyString, value);
        this.list.add(keyString);
        return true;
    }

    public void putIfAbsent(@NotNull CharSequence key, long value) {
        int index = this.keyIndex(key);
        if (index > -1) {
            String keyString = Chars.toString(key);
            this.putAt0(index, keyString, value);
            this.list.add(keyString);
        }
    }

    @Override
    public void removeAt(int index) {
        if (index < 0) {
            int index1 = -index - 1;
            CharSequence key = this.keys[index1];
            super.removeAt(index);
            this.list.remove(key);
        }
    }

    public long valueAt(int index) {
        int index1 = -index - 1;
        return index < 0 ? this.values[index1] : this.noEntryValue;
    }

    private void putAt0(int index, CharSequence key, long value) {
        this.keys[index] = key;
        this.values[index] = value;
        if (--this.free == 0) {
            this.rehash();
        }
    }

    private void rehash() {
        long[] oldValues = this.values;
        CharSequence[] oldKeys = this.keys;
        int size = this.capacity - this.free;
        this.capacity *= 2;
        this.free = this.capacity - size;
        this.mask = Numbers.ceilPow2((int)((double)this.capacity / this.loadFactor)) - 1;
        this.keys = new CharSequence[this.mask + 1];
        this.values = new long[this.mask + 1];
        for (int i = oldKeys.length - 1; i > -1; --i) {
            CharSequence key = oldKeys[i];
            if (key == null) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
            this.values[index] = oldValues[i];
        }
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = noEntryKey;
        this.values[index] = this.noEntryValue;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.values[to] = this.values[from];
        this.erase(from);
    }
}

