/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.std.DirectObjectFactory;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjectFactory;
import io.questdb.std.Unsafe;
import java.io.Closeable;

public class RingQueue<T>
implements Closeable {
    private final T[] buf;
    private final int mask;
    private final int memoryTag;
    private long memory;
    private long memorySize;

    public RingQueue(ObjectFactory<T> factory, int cycle) {
        assert (cycle == 0 || Numbers.isPow2(cycle));
        try {
            this.mask = cycle - 1;
            this.buf = new Object[cycle];
            for (int i = 0; i < cycle; ++i) {
                this.buf[i] = factory.newInstance();
            }
            this.memory = 0L;
            this.memorySize = 0L;
            this.memoryTag = 0;
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    public RingQueue(DirectObjectFactory<T> factory, long slotSize, int cycle, int memoryTag) {
        try {
            this.mask = cycle - 1;
            this.buf = new Object[cycle];
            this.memorySize = slotSize * (long)cycle;
            this.memoryTag = memoryTag;
            long p = this.memory = Unsafe.calloc(this.memorySize, memoryTag);
            for (int i = 0; i < cycle; ++i) {
                this.buf[i] = factory.newInstance(p, slotSize);
                p += slotSize;
            }
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void close() {
        int n = this.buf.length;
        for (int i = 0; i < n; ++i) {
            this.buf[i] = Misc.freeIfCloseable(this.buf[i]);
        }
        if (this.memory != 0L) {
            this.memory = Unsafe.free(this.memory, this.memorySize, this.memoryTag);
            this.memorySize = 0L;
        }
    }

    public T get(long cursor) {
        return this.buf[(int)(cursor & (long)this.mask)];
    }

    public int getCycle() {
        return this.buf.length;
    }
}

