/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.VirtualFunctionRecord;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.join.JoinRecord;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class VirtualFunctionRecordCursor
implements RecordCursor {
    protected final VirtualFunctionRecord recordA;
    private final ObjList<Function> functions;
    private final int memoizerCount;
    private final ObjList<Function> memoizers;
    private final VirtualFunctionRecord recordB;
    private final boolean supportsRandomAccess;
    protected RecordCursor baseCursor;

    public VirtualFunctionRecordCursor(ObjList<Function> functions, ObjList<Function> memoizers, boolean supportsRandomAccess, int virtualColumnReservedSlots) {
        this.functions = functions;
        this.memoizers = memoizers;
        this.memoizerCount = memoizers.size();
        if (supportsRandomAccess) {
            this.recordA = new VirtualFunctionRecord(functions, virtualColumnReservedSlots);
            this.recordB = new VirtualFunctionRecord(functions, virtualColumnReservedSlots);
        } else {
            this.recordA = new VirtualFunctionRecord(functions, virtualColumnReservedSlots);
            this.recordB = null;
        }
        this.supportsRandomAccess = supportsRandomAccess;
    }

    @Override
    public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
        assert (this.baseCursor != null);
        this.baseCursor.calculateSize(circuitBreaker, counter);
    }

    @Override
    public void close() {
        this.baseCursor = Misc.free(this.baseCursor);
        int n = this.functions.size();
        for (int i = 0; i < n; ++i) {
            this.functions.getQuick(i).cursorClosed();
        }
    }

    @Override
    public Record getRecord() {
        return this.recordA;
    }

    @Override
    public Record getRecordB() {
        if (this.supportsRandomAccess) {
            return this.recordB;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return (SymbolTable)((Object)this.functions.getQuick(columnIndex));
    }

    @Override
    public boolean hasNext() {
        boolean result = this.baseCursor.hasNext();
        if (result && this.memoizerCount > 0) {
            this.memoizeFunctions(this.recordA);
        }
        return result;
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return ((SymbolFunction)this.functions.getQuick(columnIndex)).newSymbolTable();
    }

    public void of(RecordCursor cursor) {
        this.baseCursor = cursor;
        this.recordA.of(this.baseCursor.getRecord());
        if (this.recordB != null) {
            this.recordB.of(this.baseCursor.getRecordB());
        }
        cursor.toTop();
    }

    @Override
    public long preComputedStateSize() {
        return 0L;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        if (this.supportsRandomAccess) {
            assert (this.baseCursor != null);
        } else {
            throw new UnsupportedOperationException();
        }
        this.baseCursor.recordAt(((VirtualFunctionRecord)record).getBaseRecord(), atRowId);
        this.memoizeFunctions((VirtualFunctionRecord)record);
    }

    @Override
    public long size() {
        assert (this.baseCursor != null);
        return this.baseCursor.size();
    }

    @Override
    public void skipRows(RecordCursor.Counter rowCount) throws DataUnavailableException {
        assert (this.baseCursor != null);
        this.baseCursor.skipRows(rowCount);
    }

    @Override
    public void toTop() {
        assert (this.baseCursor != null);
        this.baseCursor.toTop();
        GroupByUtils.toTop(this.functions);
    }

    private void memoizeFunctions(VirtualFunctionRecord record) {
        JoinRecord joinRecord = record.getInternalJoinRecord();
        for (int i = 0; i < this.memoizerCount; ++i) {
            this.memoizers.getQuick(i).memoize(joinRecord);
        }
    }
}

