/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoColumn;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoTable;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.MetadataCacheReader;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import org.jetbrains.annotations.NotNull;

public class ShowColumnsRecordCursorFactory
extends AbstractRecordCursorFactory {
    public static final int N_NAME_COL = 0;
    public static final int N_TYPE_COL = 1;
    private static final int N_INDEXED_COL = 2;
    private static final int N_INDEX_BLOCK_CAPACITY_COL = 3;
    private static final int N_SYMBOL_CACHED_COL = 4;
    private static final int N_SYMBOL_CAPACITY_COL = 5;
    private static final int N_DESIGNATED_COL = 6;
    private static final int N_UPSERT_KEY_COL = 7;
    private static final RecordMetadata METADATA;
    private final ShowColumnsCursor cursor = new ShowColumnsCursor();
    private final TableToken tableToken;
    private final int tokenPosition;

    public ShowColumnsRecordCursorFactory(TableToken tableToken, int tokenPosition) {
        super(METADATA);
        this.tableToken = tableToken;
        this.tokenPosition = tokenPosition;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        return this.cursor.of(executionContext, this.tableToken, this.tokenPosition);
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("show_columns");
        sink.meta("of").val(this.tableToken.getTableName());
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("column", 11));
        metadata.add(new TableColumnMetadata("type", 11));
        metadata.add(new TableColumnMetadata("indexed", 1));
        metadata.add(new TableColumnMetadata("indexBlockCapacity", 5));
        metadata.add(new TableColumnMetadata("symbolCached", 1));
        metadata.add(new TableColumnMetadata("symbolCapacity", 5));
        metadata.add(new TableColumnMetadata("designated", 1));
        metadata.add(new TableColumnMetadata("upsertKey", 1));
        METADATA = metadata;
    }

    public static class ShowColumnsCursor
    implements NoRandomAccessRecordCursor {
        private final ShowColumnsRecord record = new ShowColumnsRecord();
        private CairoColumn cairoColumn = new CairoColumn();
        private CairoTable cairoTable;
        private int columnIndex;

        @Override
        public void close() {
            this.cairoTable = null;
            this.cairoColumn = null;
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            ++this.columnIndex;
            this.cairoColumn = this.cairoTable.getColumnQuiet(this.columnIndex);
            return this.cairoColumn != null;
        }

        public ShowColumnsCursor of(CairoTable table) {
            this.cairoTable = table;
            this.toTop();
            return this;
        }

        public ShowColumnsCursor of(SqlExecutionContext executionContext, TableToken tableToken, int tokenPosition) {
            try (MetadataCacheReader metadataRO = executionContext.getCairoEngine().getMetadataCache().readLock();){
                CairoTable table = metadataRO.getTable(tableToken);
                if (table != null) {
                    ShowColumnsCursor showColumnsCursor = this.of(table);
                    return showColumnsCursor;
                }
            }
            throw CairoException.tableDoesNotExist(tableToken.getTableName()).position(tokenPosition);
        }

        public ShowColumnsCursor of(SqlExecutionContext executionContext, CharSequence tableName) throws CairoException {
            CairoEngine engine = executionContext.getCairoEngine();
            TableToken tableToken = engine.getTableTokenIfExists(tableName);
            if (tableToken == null) {
                throw CairoException.tableDoesNotExist(tableName);
            }
            return this.of(executionContext, tableToken, -1);
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.columnIndex = -1;
            this.cairoColumn = null;
        }

        public class ShowColumnsRecord
        implements Record {
            @Override
            public boolean getBool(int col) {
                if (col == 2) {
                    return ShowColumnsCursor.this.cairoColumn.isIndexed();
                }
                if (col == 4) {
                    return ShowColumnsCursor.this.cairoColumn.isSymbolCached();
                }
                if (col == 6) {
                    return ShowColumnsCursor.this.cairoColumn.isDesignated();
                }
                if (col == 7) {
                    return ShowColumnsCursor.this.cairoColumn.isDedupKey();
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public int getInt(int col) {
                if (col == 3) {
                    return ShowColumnsCursor.this.cairoColumn.getIndexBlockCapacity();
                }
                if (col == 5) {
                    if (ColumnType.isSymbol(ShowColumnsCursor.this.cairoColumn.getType())) {
                        return ShowColumnsCursor.this.cairoColumn.getSymbolCapacity();
                    }
                    return 0;
                }
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public CharSequence getStrA(int col) {
                if (col == 0) {
                    return ShowColumnsCursor.this.cairoColumn.getName();
                }
                if (col == 1) {
                    return ColumnType.nameOf(ShowColumnsCursor.this.cairoColumn.getType());
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getStrA(col);
            }

            @Override
            public int getStrLen(int col) {
                return this.getStrA(col).length();
            }
        }
    }
}

