/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.PartitionFrameCursorFactory;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractPageFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.DeferredSymbolIndexFilteredRowCursorFactory;
import io.questdb.griffin.engine.table.DeferredSymbolIndexRowCursorFactory;
import io.questdb.griffin.engine.table.FunctionBasedRowCursorFactory;
import io.questdb.griffin.engine.table.HeapRowCursorFactory;
import io.questdb.griffin.engine.table.PageFrameRecordCursorImpl;
import io.questdb.griffin.engine.table.SequentialRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexFilteredRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexRowCursorFactory;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterOnValuesRecordCursorFactory
extends AbstractPageFrameRecordCursorFactory {
    private static final Comparator<FunctionBasedRowCursorFactory> COMPARATOR = FilterOnValuesRecordCursorFactory::compareStrFunctions;
    private static final Comparator<FunctionBasedRowCursorFactory> COMPARATOR_DESC = FilterOnValuesRecordCursorFactory::compareStrFunctionsDesc;
    private final int columnIndex;
    private final PageFrameRecordCursorImpl cursor;
    private final ObjList<FunctionBasedRowCursorFactory> cursorFactories;
    private final int[] cursorFactoriesIdx;
    private final Function filter;
    private final boolean followedOrderByAdvice;
    private final boolean heapCursorUsed;
    private final int orderDirection;
    private final RowCursorFactory rowCursorFactory;

    public FilterOnValuesRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull PartitionFrameCursorFactory partitionFrameCursorFactory, @NotNull ObjList<Function> keyValues, int columnIndex, @NotNull TableReader reader, @Nullable Function filter, int orderByMnemonic, boolean orderByKeyColumn, boolean orderByTimestamp, int orderDirection, int indexDirection, @NotNull IntList columnIndexes, @NotNull IntList columnSizeShifts) {
        super(configuration, metadata, partitionFrameCursorFactory, columnIndexes, columnSizeShifts);
        int nKeyValues = keyValues.size();
        this.columnIndex = columnIndex;
        this.filter = filter;
        this.orderDirection = orderDirection;
        this.cursorFactories = new ObjList(nKeyValues);
        this.cursorFactoriesIdx = new int[]{0};
        SymbolMapReader symbolMapReader = reader.getSymbolMapReader(columnIndexes.getQuick(columnIndex));
        for (int i = 0; i < nKeyValues; ++i) {
            Function symbol = keyValues.get(i);
            if (symbol.isConstant()) {
                this.addSymbolKey(symbolMapReader.keyOf(symbol.getStrA(null)), symbol, indexDirection);
                continue;
            }
            this.addSymbolKey(-2, symbol, indexDirection);
        }
        if (orderByMnemonic == 2 && !orderByTimestamp) {
            this.heapCursorUsed = false;
            this.rowCursorFactory = new SequentialRowCursorFactory(this.cursorFactories, this.cursorFactoriesIdx);
        } else {
            this.heapCursorUsed = true;
            this.rowCursorFactory = new HeapRowCursorFactory(this.cursorFactories, this.cursorFactoriesIdx);
        }
        this.cursor = new PageFrameRecordCursorImpl(configuration, metadata, this.rowCursorFactory, false, filter);
        this.followedOrderByAdvice = orderByKeyColumn || orderByTimestamp;
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.followedOrderByAdvice;
    }

    @Override
    public int getScanDirection() {
        if (this.partitionFrameCursorFactory.getOrder() == 0 && this.heapCursorUsed) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("FilterOnValues");
        if (!this.heapCursorUsed) {
            sink.meta("symbolOrder").val(this.followedOrderByAdvice && this.orderDirection == 0 ? "asc" : "desc");
        }
        sink.child(this.rowCursorFactory);
        sink.child(this.partitionFrameCursorFactory);
    }

    @Override
    public boolean usesIndex() {
        return true;
    }

    private static int compareStrFunctions(FunctionBasedRowCursorFactory a, FunctionBasedRowCursorFactory b) {
        return Chars.compare(a.getFunction().getStrA(null), b.getFunction().getStrB(null));
    }

    private static int compareStrFunctionsDesc(FunctionBasedRowCursorFactory a, FunctionBasedRowCursorFactory b) {
        return Chars.compareDescending(a.getFunction().getStrA(null), b.getFunction().getStrB(null));
    }

    private static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == null) {
            return cs2 == null;
        }
        return cs2 != null && Chars.equals(cs1, cs2);
    }

    private void addSymbolKey(int symbolKey, Function symbolFunction, int indexDirection) {
        FunctionBasedRowCursorFactory rowCursorFactory = this.filter == null ? (symbolKey == -2 ? new DeferredSymbolIndexRowCursorFactory(this.columnIndex, symbolFunction, this.cursorFactories.size() == 0, indexDirection) : new SymbolIndexRowCursorFactory(this.columnIndex, symbolKey, this.cursorFactories.size() == 0, indexDirection, symbolFunction)) : (symbolKey == -2 ? new DeferredSymbolIndexFilteredRowCursorFactory(this.columnIndex, symbolFunction, this.filter, this.cursorFactories.size() == 0, indexDirection) : new SymbolIndexFilteredRowCursorFactory(this.columnIndex, symbolKey, this.filter, this.cursorFactories.size() == 0, indexDirection, symbolFunction));
        this.cursorFactories.add(rowCursorFactory);
    }

    private void findDuplicates() {
        int idx = 0;
        int max = this.cursorFactories.size();
        block0: while (idx < max - 1) {
            CharSequence symbol = this.symbol(idx);
            ++idx;
            while (FilterOnValuesRecordCursorFactory.equals(symbol, this.symbol(idx))) {
                FunctionBasedRowCursorFactory tmp = this.cursorFactories.get(idx);
                this.cursorFactories.remove(idx);
                this.cursorFactories.add(tmp);
                if (++idx < --max) continue;
                break block0;
            }
        }
        this.cursorFactoriesIdx[0] = max;
    }

    private CharSequence symbol(int idx) {
        return this.cursorFactories.get(idx).getFunction().getSymbol(null);
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.filter);
        Misc.free(this.cursor);
    }

    @Override
    protected RecordCursor initRecordCursor(PageFrameCursor pageFrameCursor, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int n = this.cursorFactories.size();
        for (int i = 0; i < n; ++i) {
            this.cursorFactories.getQuick(i).getFunction().init(pageFrameCursor, sqlExecutionContext);
        }
        if (this.followedOrderByAdvice && this.orderDirection == 0) {
            this.cursorFactories.sort(COMPARATOR);
        } else {
            this.cursorFactories.sort(COMPARATOR_DESC);
        }
        this.findDuplicates();
        this.cursor.of(pageFrameCursor, sqlExecutionContext);
        if (this.filter != null) {
            this.filter.init(this.cursor, sqlExecutionContext);
        }
        return this.cursor;
    }
}

