/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.window;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.WindowSPI;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.window.AbstractWindowFunctionFactory;
import io.questdb.griffin.engine.functions.window.BasePartitionedWindowFunction;
import io.questdb.griffin.engine.functions.window.BaseWindowFunction;
import io.questdb.griffin.engine.functions.window.WindowDoubleFunction;
import io.questdb.griffin.engine.window.WindowContext;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

public class MaxDoubleWindowFunctionFactory
extends AbstractWindowFunctionFactory {
    public static final DoubleComparator GREATER_THAN = (a, b) -> Double.compare(a, b) > 0;
    public static final ArrayColumnTypes MAX_COLUMN_TYPES = new ArrayColumnTypes();
    public static final ArrayColumnTypes MAX_OVER_PARTITION_RANGE_BOUNDED_COLUMN_TYPES;
    public static final ArrayColumnTypes MAX_OVER_PARTITION_RANGE_COLUMN_TYPES;
    public static final ArrayColumnTypes MAX_OVER_PARTITION_ROWS_BOUNDED_COLUMN_TYPES;
    public static final ArrayColumnTypes MAX_OVER_PARTITION_ROWS_COLUMN_TYPES;
    public static final String NAME = "max";
    private static final String SIGNATURE = "max(D)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        WindowContext windowContext = sqlExecutionContext.getWindowContext();
        windowContext.validate(position, this.supportNullsDesc());
        int framingMode = windowContext.getFramingMode();
        RecordSink partitionBySink = windowContext.getPartitionBySink();
        ColumnTypes partitionByKeyTypes = windowContext.getPartitionByKeyTypes();
        VirtualRecord partitionByRecord = windowContext.getPartitionByRecord();
        long rowsLo = windowContext.getRowsLo();
        long rowsHi = windowContext.getRowsHi();
        if (rowsHi < rowsLo) {
            return new AbstractWindowFunctionFactory.DoubleNullFunction(args.get(0), NAME, rowsLo, rowsHi, framingMode == 1, partitionByRecord);
        }
        if (partitionByRecord != null) {
            if (framingMode == 1) {
                if (windowContext.isDefaultFrame() && (!windowContext.isOrdered() || windowContext.getRowsHi() == Long.MAX_VALUE)) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, MAX_COLUMN_TYPES);
                    return new MaxMinOverPartitionFunction(map, partitionByRecord, partitionBySink, args.get(0), GREATER_THAN, NAME);
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, MAX_COLUMN_TYPES);
                    return new MaxMinOverUnboundedPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, args.get(0), GREATER_THAN, NAME);
                }
                if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                    throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                }
                int timestampIndex = windowContext.getTimestampIndex();
                Map map = null;
                MemoryCARW mem = null;
                MemoryCARW dequeMem = null;
                try {
                    map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, rowsLo == Long.MIN_VALUE ? MAX_OVER_PARTITION_RANGE_COLUMN_TYPES : MAX_OVER_PARTITION_RANGE_BOUNDED_COLUMN_TYPES);
                    mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                    if (rowsLo != Long.MIN_VALUE) {
                        dequeMem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                    }
                    return new MaxMinOverPartitionRangeFrameFunction(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, args.get(0), mem, dequeMem, configuration.getSqlWindowInitialRangeBufferSize(), timestampIndex, GREATER_THAN, NAME);
                }
                catch (Throwable th) {
                    Misc.free(map);
                    Misc.free(mem);
                    Misc.free(dequeMem);
                    throw th;
                }
            }
            if (framingMode == 2) {
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, MAX_COLUMN_TYPES);
                    return new MaxMinOverUnboundedPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, args.get(0), GREATER_THAN, NAME);
                }
                if (rowsLo == 0L && rowsLo == rowsHi) {
                    return new MaxMinOverCurrentRowFunction(args.get(0), NAME);
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == Long.MAX_VALUE) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, MAX_COLUMN_TYPES);
                    return new MaxMinOverPartitionFunction(map, partitionByRecord, partitionBySink, args.get(0), GREATER_THAN, NAME);
                }
                Map map = null;
                MemoryCARW mem = null;
                MemoryCARW dequeMem = null;
                try {
                    map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, rowsLo == Long.MIN_VALUE ? MAX_OVER_PARTITION_ROWS_COLUMN_TYPES : MAX_OVER_PARTITION_ROWS_BOUNDED_COLUMN_TYPES);
                    mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                    if (rowsLo != Long.MIN_VALUE) {
                        dequeMem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                    }
                    return new MaxMinOverPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, args.get(0), mem, dequeMem, GREATER_THAN, NAME);
                }
                catch (Throwable th) {
                    Misc.free(map);
                    Misc.free(mem);
                    Misc.free(dequeMem);
                    throw th;
                }
            }
        } else {
            if (framingMode == 1) {
                if (!windowContext.isOrdered() && windowContext.isDefaultFrame()) {
                    return new MaxMinOverWholeResultSetFunction(args.get(0), GREATER_THAN, NAME);
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    return new MaxMinOverUnboundedRowsFrameFunction(args.get(0), GREATER_THAN, NAME);
                }
                if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                    throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                }
                int timestampIndex = windowContext.getTimestampIndex();
                MemoryCARW mem = null;
                MemoryCARW dequeMem = null;
                try {
                    mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                    if (rowsLo != Long.MIN_VALUE) {
                        dequeMem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                    }
                    return new MaxMinOverRangeFrameFunction(rowsLo, rowsHi, args.get(0), configuration, mem, dequeMem, timestampIndex, GREATER_THAN, NAME);
                }
                catch (Throwable th) {
                    Misc.free(mem);
                    Misc.free(dequeMem);
                    throw th;
                }
            }
            if (framingMode == 2) {
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    return new MaxMinOverUnboundedRowsFrameFunction(args.get(0), GREATER_THAN, NAME);
                }
                if (rowsLo == 0L && rowsLo == rowsHi) {
                    return new MaxMinOverCurrentRowFunction(args.get(0), NAME);
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == Long.MAX_VALUE) {
                    return new MaxMinOverWholeResultSetFunction(args.get(0), GREATER_THAN, NAME);
                }
                MemoryCARW mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                MemoryCARW dequeMem = null;
                if (rowsLo != Long.MIN_VALUE) {
                    dequeMem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                }
                return new MaxMinOverRowsFrameFunction(args.get(0), rowsLo, rowsHi, mem, dequeMem, GREATER_THAN, NAME);
            }
        }
        throw SqlException.$(position, "function not implemented for given window parameters");
    }

    static {
        MAX_COLUMN_TYPES.add(10);
        MAX_OVER_PARTITION_RANGE_COLUMN_TYPES = new ArrayColumnTypes();
        MAX_OVER_PARTITION_RANGE_COLUMN_TYPES.add(6);
        MAX_OVER_PARTITION_RANGE_COLUMN_TYPES.add(6);
        MAX_OVER_PARTITION_RANGE_COLUMN_TYPES.add(6);
        MAX_OVER_PARTITION_RANGE_COLUMN_TYPES.add(6);
        MAX_OVER_PARTITION_RANGE_COLUMN_TYPES.add(6);
        MAX_OVER_PARTITION_RANGE_COLUMN_TYPES.add(10);
        MAX_OVER_PARTITION_RANGE_BOUNDED_COLUMN_TYPES = new ArrayColumnTypes();
        MAX_OVER_PARTITION_RANGE_BOUNDED_COLUMN_TYPES.add(6);
        MAX_OVER_PARTITION_RANGE_BOUNDED_COLUMN_TYPES.add(6);
        MAX_OVER_PARTITION_RANGE_BOUNDED_COLUMN_TYPES.add(6);
        MAX_OVER_PARTITION_RANGE_BOUNDED_COLUMN_TYPES.add(6);
        MAX_OVER_PARTITION_RANGE_BOUNDED_COLUMN_TYPES.add(6);
        MAX_OVER_PARTITION_RANGE_BOUNDED_COLUMN_TYPES.add(6);
        MAX_OVER_PARTITION_RANGE_BOUNDED_COLUMN_TYPES.add(6);
        MAX_OVER_PARTITION_RANGE_BOUNDED_COLUMN_TYPES.add(6);
        MAX_OVER_PARTITION_RANGE_BOUNDED_COLUMN_TYPES.add(6);
        MAX_OVER_PARTITION_ROWS_COLUMN_TYPES = new ArrayColumnTypes();
        MAX_OVER_PARTITION_ROWS_COLUMN_TYPES.add(6);
        MAX_OVER_PARTITION_ROWS_COLUMN_TYPES.add(6);
        MAX_OVER_PARTITION_ROWS_COLUMN_TYPES.add(10);
        MAX_OVER_PARTITION_ROWS_BOUNDED_COLUMN_TYPES = new ArrayColumnTypes();
        MAX_OVER_PARTITION_ROWS_BOUNDED_COLUMN_TYPES.add(6);
        MAX_OVER_PARTITION_ROWS_BOUNDED_COLUMN_TYPES.add(6);
        MAX_OVER_PARTITION_ROWS_BOUNDED_COLUMN_TYPES.add(6);
        MAX_OVER_PARTITION_ROWS_BOUNDED_COLUMN_TYPES.add(6);
        MAX_OVER_PARTITION_ROWS_BOUNDED_COLUMN_TYPES.add(6);
    }

    static class MaxMinOverPartitionFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        private final DoubleComparator comparator;
        private final String name;

        public MaxMinOverPartitionFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, Function arg, DoubleComparator comparator, String name) {
            super(map, partitionByRecord, partitionBySink, arg);
            this.name = name;
            this.comparator = comparator;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getPassCount() {
            return 2;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            double d = this.arg.getDouble(record);
            if (Numbers.isFinite(d)) {
                this.partitionByRecord.of(record);
                MapKey key = this.map.withKey();
                key.put(this.partitionByRecord, this.partitionBySink);
                MapValue value = key.createValue();
                if (!value.isNew()) {
                    if (this.comparator.compare(d, value.getDouble(0))) {
                        value.putDouble(0, d);
                    }
                } else {
                    value.putDouble(0, d);
                }
            }
        }

        @Override
        public void pass2(Record record, long recordOffset, WindowSPI spi) {
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.findValue();
            double val = value != null ? value.getDouble(0) : Double.NaN;
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), val);
        }
    }

    @FunctionalInterface
    public static interface DoubleComparator {
        public boolean compare(double var1, double var3);
    }

    static class MaxMinOverUnboundedPartitionRowsFrameFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        private final DoubleComparator comparator;
        private final String name;
        private double maxMin;

        public MaxMinOverUnboundedPartitionRowsFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, Function arg, DoubleComparator comparator, String name) {
            super(map, partitionByRecord, partitionBySink, arg);
            this.comparator = comparator;
            this.name = name;
        }

        @Override
        public void computeNext(Record record) {
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            double d = this.arg.getDouble(record);
            if (Numbers.isFinite(d)) {
                MapValue value = key.createValue();
                if (value.isNew()) {
                    value.putDouble(0, d);
                    this.maxMin = d;
                } else {
                    double max = value.getDouble(0);
                    if (this.comparator.compare(d, max)) {
                        value.putDouble(0, d);
                        max = d;
                    }
                    this.maxMin = max;
                }
            } else {
                MapValue value = key.findValue();
                this.maxMin = value != null ? value.getDouble(0) : Double.NaN;
            }
        }

        @Override
        public double getDouble(Record rec) {
            return this.maxMin;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.maxMin);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(" rows between unbounded preceding and current row)");
        }
    }

    public static class MaxMinOverPartitionRangeFrameFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        private static final int DEQUE_RECORD_SIZE = 8;
        private static final int RECORD_SIZE = 16;
        private final DoubleComparator comparator;
        private final LongList dequeFreeList = new LongList();
        private final int dequeInitialBufferSize;
        private final MemoryARW dequeMemory;
        private final boolean frameIncludesCurrentValue;
        private final boolean frameLoBounded;
        private final LongList freeList = new LongList();
        private final int initialBufferSize;
        private final long maxDiff;
        private final MemoryARW memory;
        private final AbstractWindowFunctionFactory.RingBufferDesc memoryDesc = new AbstractWindowFunctionFactory.RingBufferDesc();
        private final long minDiff;
        private final String name;
        private final int timestampIndex;
        private double maxMin;

        public MaxMinOverPartitionRangeFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, long rangeLo, long rangeHi, Function arg, MemoryARW memory, MemoryARW dequeMemory, int initialBufferSize, int timestampIdx, DoubleComparator comparator, String name) {
            super(map, partitionByRecord, partitionBySink, arg);
            this.frameLoBounded = rangeLo != Long.MIN_VALUE;
            this.maxDiff = this.frameLoBounded ? Math.abs(rangeLo) : Long.MAX_VALUE;
            this.minDiff = Math.abs(rangeHi);
            this.memory = memory;
            this.initialBufferSize = initialBufferSize;
            this.timestampIndex = timestampIdx;
            this.frameIncludesCurrentValue = rangeHi == 0L;
            this.dequeMemory = dequeMemory;
            this.dequeInitialBufferSize = initialBufferSize;
            this.comparator = comparator;
            this.name = name;
        }

        @Override
        public void close() {
            super.close();
            this.memory.close();
            this.freeList.clear();
            this.dequeFreeList.clear();
            if (this.dequeMemory != null) {
                this.dequeMemory.close();
            }
        }

        @Override
        public void computeNext(Record record) {
            long size;
            long frameSize;
            long firstIdx;
            long startOffset;
            long capacity;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue mapValue = key.createValue();
            long dequeStartOffset = 0L;
            long dequeCapacity = 0L;
            long dequeStartIndex = 0L;
            long dequeEndIndex = 0L;
            long timestamp = record.getTimestamp(this.timestampIndex);
            double d = this.arg.getDouble(record);
            if (mapValue.isNew()) {
                capacity = this.initialBufferSize;
                startOffset = this.memory.appendAddressFor(capacity * 16L) - this.memory.getPageAddress(0);
                firstIdx = 0L;
                if (this.frameLoBounded) {
                    dequeCapacity = this.dequeInitialBufferSize;
                    dequeStartOffset = this.dequeMemory.appendAddressFor(dequeCapacity * 8L) - this.dequeMemory.getPageAddress(0);
                }
                if (Numbers.isFinite(d)) {
                    this.memory.putLong(startOffset, timestamp);
                    this.memory.putDouble(startOffset + 8L, d);
                    if (this.frameIncludesCurrentValue) {
                        this.maxMin = d;
                        frameSize = 1L;
                        size = this.frameLoBounded ? 1L : 0L;
                    } else {
                        this.maxMin = Double.NaN;
                        frameSize = 0L;
                        size = 1L;
                    }
                    if (this.frameLoBounded && this.frameIncludesCurrentValue) {
                        this.dequeMemory.putDouble(dequeStartOffset, d);
                        ++dequeEndIndex;
                    }
                } else {
                    size = 0L;
                    this.maxMin = Double.NaN;
                    frameSize = 0L;
                }
            } else {
                long i;
                frameSize = mapValue.getLong(0);
                startOffset = mapValue.getLong(1);
                size = mapValue.getLong(2);
                capacity = mapValue.getLong(3);
                long newFirstIdx = firstIdx = mapValue.getLong(4);
                if (this.frameLoBounded) {
                    long idx;
                    long ts;
                    dequeStartOffset = mapValue.getLong(5);
                    dequeCapacity = mapValue.getLong(6);
                    dequeStartIndex = mapValue.getLong(7);
                    dequeEndIndex = mapValue.getLong(8);
                    long n = size;
                    for (i = 0L; i < n && Math.abs(timestamp - (ts = this.memory.getLong(startOffset + (idx = (firstIdx + i) % capacity) * 16L))) > this.maxDiff; ++i) {
                        if (frameSize > 0L) {
                            if (dequeStartIndex != dequeEndIndex && this.dequeMemory.getDouble(dequeStartOffset + dequeStartIndex % dequeCapacity * 8L) == this.memory.getDouble(startOffset + idx * 16L + 8L)) {
                                ++dequeStartIndex;
                            }
                            --frameSize;
                        }
                        newFirstIdx = (idx + 1L) % capacity;
                        --size;
                    }
                }
                firstIdx = newFirstIdx;
                if (Numbers.isFinite(d)) {
                    if (size == capacity) {
                        this.memoryDesc.reset(capacity, startOffset, size, firstIdx, this.freeList);
                        AbstractWindowFunctionFactory.expandRingBuffer(this.memory, this.memoryDesc, 16);
                        capacity = this.memoryDesc.capacity;
                        startOffset = this.memoryDesc.startOffset;
                        firstIdx = this.memoryDesc.firstIdx;
                    }
                    this.memory.putLong(startOffset + (firstIdx + size) % capacity * 16L, timestamp);
                    this.memory.putDouble(startOffset + (firstIdx + size) % capacity * 16L + 8L, d);
                    ++size;
                }
                if (this.frameLoBounded) {
                    long idx;
                    long ts;
                    long diff;
                    for (i = frameSize; i < size && (diff = Math.abs((ts = this.memory.getLong(startOffset + (idx = (firstIdx + i) % capacity) * 16L)) - timestamp)) <= this.maxDiff && diff >= this.minDiff; ++i) {
                        double value = this.memory.getDouble(startOffset + idx * 16L + 8L);
                        while (dequeStartIndex != dequeEndIndex && this.comparator.compare(value, this.dequeMemory.getDouble(dequeStartOffset + (dequeEndIndex - 1L) % dequeCapacity * 8L))) {
                            --dequeEndIndex;
                        }
                        if (dequeEndIndex - dequeStartIndex == dequeCapacity) {
                            this.memoryDesc.reset(dequeCapacity, dequeStartOffset, dequeEndIndex - dequeStartIndex, dequeStartIndex, this.dequeFreeList);
                            AbstractWindowFunctionFactory.expandRingBuffer(this.dequeMemory, this.memoryDesc, 8);
                            dequeCapacity = this.memoryDesc.capacity;
                            dequeStartOffset = this.memoryDesc.startOffset;
                            dequeStartIndex = this.memoryDesc.firstIdx;
                            dequeEndIndex = dequeStartIndex + this.memoryDesc.size;
                        }
                        this.dequeMemory.putDouble(dequeStartOffset + dequeEndIndex % dequeCapacity * 8L, value);
                        ++dequeEndIndex;
                        ++frameSize;
                    }
                    this.maxMin = dequeStartIndex == dequeEndIndex ? Double.NaN : this.dequeMemory.getDouble(dequeStartOffset + dequeStartIndex % dequeCapacity * 8L);
                } else {
                    long idx;
                    long ts;
                    double oldMax = mapValue.getDouble(5);
                    newFirstIdx = firstIdx;
                    long n = size;
                    for (long i2 = 0L; i2 < n && Math.abs(timestamp - (ts = this.memory.getLong(startOffset + (idx = (firstIdx + i2) % capacity) * 16L))) >= this.minDiff; ++i2) {
                        double val = this.memory.getDouble(startOffset + idx * 16L + 8L);
                        if (Numbers.isNull(oldMax) || this.comparator.compare(val, oldMax)) {
                            oldMax = val;
                        }
                        ++frameSize;
                        newFirstIdx = (idx + 1L) % capacity;
                        --size;
                    }
                    firstIdx = newFirstIdx;
                    this.maxMin = oldMax;
                }
            }
            mapValue.putLong(0, frameSize);
            mapValue.putLong(1, startOffset);
            mapValue.putLong(2, size);
            mapValue.putLong(3, capacity);
            mapValue.putLong(4, firstIdx);
            if (this.frameLoBounded) {
                mapValue.putLong(5, dequeStartOffset);
                mapValue.putLong(6, dequeCapacity);
                mapValue.putLong(7, dequeStartIndex);
                mapValue.putLong(8, dequeEndIndex);
            } else {
                mapValue.putDouble(5, this.maxMin);
            }
        }

        @Override
        public double getDouble(Record rec) {
            return this.maxMin;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reopen() {
            super.reopen();
            this.maxMin = Double.NaN;
        }

        @Override
        public void reset() {
            super.reset();
            this.memory.close();
            this.freeList.clear();
            this.dequeFreeList.clear();
            if (this.dequeMemory != null) {
                this.dequeMemory.close();
            }
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(" range between ");
            if (this.frameLoBounded) {
                sink.val(this.maxDiff);
            } else {
                sink.val("unbounded");
            }
            sink.val(" preceding and ");
            if (this.minDiff == 0L) {
                sink.val("current row");
            } else {
                sink.val(this.minDiff).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.memory.truncate();
            this.freeList.clear();
            this.dequeFreeList.clear();
            if (this.dequeMemory != null) {
                this.dequeMemory.truncate();
            }
        }
    }

    static class MaxMinOverCurrentRowFunction
    extends BaseWindowFunction
    implements WindowDoubleFunction {
        private final String name;
        private double value;

        MaxMinOverCurrentRowFunction(Function arg, String name) {
            super(arg);
            this.name = name;
        }

        @Override
        public void computeNext(Record record) {
            this.value = this.arg.getDouble(record);
        }

        @Override
        public double getDouble(Record rec) {
            return this.value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.value);
        }
    }

    public static class MaxMinOverPartitionRowsFrameFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        private final int bufferSize;
        private final DoubleComparator comparator;
        private final int dequeBufferSize;
        private final MemoryARW dequeMemory;
        private final boolean frameIncludesCurrentValue;
        private final boolean frameLoBounded;
        private final int frameSize;
        private final MemoryARW memory;
        private final String name;
        private double maxMin;

        public MaxMinOverPartitionRowsFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, long rowsLo, long rowsHi, Function arg, MemoryARW memory, MemoryARW dequeMemory, DoubleComparator comparator, String name) {
            super(map, partitionByRecord, partitionBySink, arg);
            if (rowsLo > Long.MIN_VALUE) {
                this.frameSize = (int)(rowsHi - rowsLo + (long)(rowsHi < 0L ? 1 : 0));
                this.bufferSize = (int)Math.abs(rowsLo);
                this.frameLoBounded = true;
                this.dequeBufferSize = (int)(rowsHi - rowsLo + 1L);
            } else {
                this.frameSize = 1;
                this.bufferSize = (int)Math.abs(rowsHi);
                this.frameLoBounded = false;
                this.dequeBufferSize = 0;
            }
            this.frameIncludesCurrentValue = rowsHi == 0L;
            this.memory = memory;
            this.dequeMemory = dequeMemory;
            this.comparator = comparator;
            this.name = name;
        }

        @Override
        public void close() {
            super.close();
            this.memory.close();
        }

        @Override
        public void computeNext(Record record) {
            long startOffset;
            long loIdx;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.createValue();
            double d = this.arg.getDouble(record);
            long dequeStartOffset = 0L;
            long dequeStartIndex = 0L;
            long dequeEndIndex = 0L;
            if (value.isNew()) {
                loIdx = 0L;
                startOffset = this.memory.appendAddressFor((long)this.bufferSize * 8L) - this.memory.getPageAddress(0);
                this.maxMin = this.frameIncludesCurrentValue && Numbers.isFinite(d) ? d : Double.NaN;
                for (int i = 0; i < this.bufferSize; ++i) {
                    this.memory.putDouble(startOffset + (long)i * 8L, Double.NaN);
                }
                if (this.frameLoBounded) {
                    dequeStartOffset = this.dequeMemory.appendAddressFor((long)this.dequeBufferSize * 8L) - this.dequeMemory.getPageAddress(0);
                    if (Numbers.isFinite(d) && this.frameIncludesCurrentValue) {
                        this.dequeMemory.putDouble(dequeStartOffset, d);
                        ++dequeEndIndex;
                    }
                } else {
                    value.putDouble(2, this.maxMin);
                }
            } else {
                double loValue;
                double hiValue;
                loIdx = value.getLong(0);
                startOffset = value.getLong(1);
                double d2 = hiValue = this.frameIncludesCurrentValue ? d : this.memory.getDouble(startOffset + (loIdx + (long)this.frameSize - 1L) % (long)this.bufferSize * 8L);
                if (this.frameLoBounded) {
                    dequeStartOffset = value.getLong(2);
                    dequeStartIndex = value.getLong(3);
                    if (Numbers.isFinite(hiValue)) {
                        for (dequeEndIndex = value.getLong(4); dequeStartIndex != dequeEndIndex && this.comparator.compare(hiValue, this.dequeMemory.getDouble(dequeStartOffset + (dequeEndIndex - 1L) % (long)this.dequeBufferSize * 8L)); --dequeEndIndex) {
                        }
                        this.dequeMemory.putDouble(dequeStartOffset + dequeEndIndex % (long)this.dequeBufferSize * 8L, hiValue);
                        ++dequeEndIndex;
                        this.maxMin = this.dequeMemory.getDouble(dequeStartOffset + dequeStartIndex % (long)this.dequeBufferSize * 8L);
                    } else {
                        this.maxMin = dequeStartIndex != dequeEndIndex ? this.dequeMemory.getDouble(dequeStartOffset + dequeStartIndex % (long)this.dequeBufferSize * 8L) : Double.NaN;
                    }
                } else {
                    double max = value.getDouble(2);
                    if (Numbers.isFinite(hiValue) && (Numbers.isNull(max) || this.comparator.compare(hiValue, max))) {
                        max = hiValue;
                        value.putDouble(2, max);
                    }
                    this.maxMin = max;
                }
                if (this.frameLoBounded && Numbers.isFinite(loValue = this.memory.getDouble(startOffset + loIdx * 8L)) && dequeStartIndex != dequeEndIndex && loValue == this.dequeMemory.getDouble(dequeStartOffset + dequeStartIndex % (long)this.dequeBufferSize * 8L)) {
                    ++dequeStartIndex;
                }
            }
            value.putLong(0, (loIdx + 1L) % (long)this.bufferSize);
            value.putLong(1, startOffset);
            if (this.frameLoBounded) {
                value.putLong(2, dequeStartOffset);
                value.putLong(3, dequeStartIndex);
                value.putLong(4, dequeEndIndex);
            }
            this.memory.putDouble(startOffset + loIdx * 8L, d);
        }

        @Override
        public double getDouble(Record rec) {
            return this.maxMin;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.maxMin);
        }

        @Override
        public void reopen() {
            super.reopen();
        }

        @Override
        public void reset() {
            super.reset();
            this.memory.close();
            if (this.dequeMemory != null) {
                this.dequeMemory.close();
            }
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(" rows between ");
            if (this.frameLoBounded) {
                sink.val(this.bufferSize);
            } else {
                sink.val("unbounded");
            }
            sink.val(" preceding and ");
            if (this.frameIncludesCurrentValue) {
                sink.val("current row");
            } else {
                sink.val(this.bufferSize - this.frameSize).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.memory.truncate();
            if (this.dequeMemory != null) {
                this.dequeMemory.truncate();
            }
        }
    }

    static class MaxMinOverWholeResultSetFunction
    extends BaseWindowFunction
    implements WindowDoubleFunction {
        private final DoubleComparator comparator;
        private final String name;
        private double maxMin = Double.NaN;

        public MaxMinOverWholeResultSetFunction(Function arg, DoubleComparator comparator, String name) {
            super(arg);
            this.comparator = comparator;
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getPassCount() {
            return 2;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            double d = this.arg.getDouble(record);
            if (Numbers.isFinite(d) && (Numbers.isNull(this.maxMin) || this.comparator.compare(d, this.maxMin))) {
                this.maxMin = d;
            }
        }

        @Override
        public void pass2(Record record, long recordOffset, WindowSPI spi) {
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.maxMin);
        }

        @Override
        public void reset() {
            super.reset();
            this.maxMin = Double.NaN;
        }

        @Override
        public void toTop() {
            super.toTop();
            this.maxMin = Double.NaN;
        }
    }

    public static class MaxMinOverUnboundedRowsFrameFunction
    extends BaseWindowFunction
    implements WindowDoubleFunction {
        private final DoubleComparator comparator;
        private final String name;
        private double maxMin = Double.NaN;

        public MaxMinOverUnboundedRowsFrameFunction(Function arg, DoubleComparator comparator, String name) {
            super(arg);
            this.comparator = comparator;
            this.name = name;
        }

        @Override
        public void computeNext(Record record) {
            double d = this.arg.getDouble(record);
            if (Numbers.isFinite(d) && (Numbers.isNull(this.maxMin) || this.comparator.compare(d, this.maxMin))) {
                this.maxMin = d;
            }
        }

        @Override
        public double getDouble(Record rec) {
            return this.maxMin;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.maxMin);
        }

        @Override
        public void reset() {
            super.reset();
            this.maxMin = Double.NaN;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            sink.val(" over (rows between unbounded preceding and current row)");
        }

        @Override
        public void toTop() {
            super.toTop();
            this.maxMin = Double.NaN;
        }
    }

    public static class MaxMinOverRangeFrameFunction
    extends BaseWindowFunction
    implements Reopenable,
    WindowDoubleFunction {
        private static final int RECORD_SIZE = 16;
        private final DoubleComparator comparator;
        private final boolean frameLoBounded;
        private final long initialCapacity;
        private final long maxDiff;
        private final MemoryARW memory;
        private final long minDiff;
        private final String name;
        private final int timestampIndex;
        private long capacity;
        private long dequeCapacity;
        private long dequeEndIndex = 0L;
        private MemoryARW dequeMemory;
        private long dequeStartIndex = 0L;
        private long dequeStartOffset;
        private long firstIdx;
        private long frameSize;
        private double maxMin;
        private long size;
        private long startOffset;

        public MaxMinOverRangeFrameFunction(long rangeLo, long rangeHi, Function arg, CairoConfiguration configuration, MemoryARW memory, MemoryARW dequeMemory, int timestampIdx, DoubleComparator comparator, String name) {
            super(arg);
            this.initialCapacity = configuration.getSqlWindowStorePageSize() / 16;
            this.memory = memory;
            this.frameLoBounded = rangeLo != Long.MIN_VALUE;
            this.maxDiff = this.frameLoBounded ? Math.abs(rangeLo) : Long.MAX_VALUE;
            this.minDiff = Math.abs(rangeHi);
            this.timestampIndex = timestampIdx;
            this.capacity = this.initialCapacity;
            this.startOffset = memory.appendAddressFor(this.capacity * 16L) - memory.getPageAddress(0);
            this.firstIdx = 0L;
            this.frameSize = 0L;
            this.maxMin = Double.NaN;
            if (this.frameLoBounded) {
                this.dequeMemory = dequeMemory;
                this.dequeCapacity = this.initialCapacity;
                this.dequeStartOffset = dequeMemory.appendAddressFor(this.dequeCapacity * 8L) - dequeMemory.getPageAddress(0);
            }
            this.comparator = comparator;
            this.name = name;
        }

        @Override
        public void close() {
            super.close();
            this.memory.close();
            if (this.dequeMemory != null) {
                this.dequeMemory.close();
            }
        }

        @Override
        public void computeNext(Record record) {
            double val;
            long idx;
            long ts;
            long i;
            long n;
            long timestamp = record.getTimestamp(this.timestampIndex);
            double d = this.arg.getDouble(record);
            long newFirstIdx = this.firstIdx;
            if (this.frameLoBounded) {
                n = this.size;
                for (i = 0L; i < n && Math.abs(timestamp - (ts = this.memory.getLong(this.startOffset + (idx = (this.firstIdx + i) % this.capacity) * 16L))) > this.maxDiff; ++i) {
                    if (this.frameSize > 0L) {
                        val = this.memory.getDouble(this.startOffset + idx * 16L + 8L);
                        if (Numbers.isFinite(val) && this.dequeStartIndex != this.dequeEndIndex && val == this.dequeMemory.getDouble(this.dequeStartOffset + this.dequeStartIndex % this.dequeCapacity * 8L)) {
                            ++this.dequeStartIndex;
                        }
                        --this.frameSize;
                    }
                    newFirstIdx = (idx + 1L) % this.capacity;
                    --this.size;
                }
            }
            this.firstIdx = newFirstIdx;
            if (Numbers.isFinite(d)) {
                if (this.size == this.capacity) {
                    long newAddress = this.memory.appendAddressFor((this.capacity << 1) * 16L);
                    long oldAddress = this.memory.getPageAddress(0) + this.startOffset;
                    if (this.firstIdx == 0L) {
                        Vect.memcpy(newAddress, oldAddress, this.size * 16L);
                    } else {
                        this.firstIdx %= this.size;
                        long firstPieceSize = (this.size - this.firstIdx) * 16L;
                        Vect.memcpy(newAddress, oldAddress + this.firstIdx * 16L, firstPieceSize);
                        Vect.memcpy(newAddress + firstPieceSize, oldAddress, this.firstIdx * 16L);
                        this.firstIdx = 0L;
                    }
                    this.startOffset = newAddress - this.memory.getPageAddress(0);
                    this.capacity <<= 1;
                }
                this.memory.putLong(this.startOffset + (this.firstIdx + this.size) % this.capacity * 16L, timestamp);
                this.memory.putDouble(this.startOffset + (this.firstIdx + this.size) % this.capacity * 16L + 8L, d);
                ++this.size;
            }
            if (this.frameLoBounded) {
                long diff;
                n = this.size;
                for (i = this.frameSize; i < n && (diff = Math.abs((ts = this.memory.getLong(this.startOffset + (idx = (this.firstIdx + i) % this.capacity) * 16L)) - timestamp)) <= this.maxDiff && diff >= this.minDiff; ++i) {
                    double value = this.memory.getDouble(this.startOffset + idx * 16L + 8L);
                    while (this.dequeStartIndex != this.dequeEndIndex && this.comparator.compare(value, this.dequeMemory.getDouble(this.dequeStartOffset + (this.dequeEndIndex - 1L) % this.dequeCapacity * 8L))) {
                        --this.dequeEndIndex;
                    }
                    if (this.dequeEndIndex - this.dequeStartIndex == this.dequeCapacity) {
                        long newAddress = this.dequeMemory.appendAddressFor((this.dequeCapacity << 1) * 8L);
                        long oldAddress = this.dequeMemory.getPageAddress(0) + this.dequeStartOffset;
                        if (this.dequeStartIndex == 0L) {
                            Vect.memcpy(newAddress, oldAddress, this.dequeCapacity * 8L);
                        } else {
                            this.dequeStartIndex %= this.dequeCapacity;
                            long firstPieceSize = (this.dequeCapacity - this.dequeStartIndex) * 8L;
                            Vect.memcpy(newAddress, oldAddress + this.dequeStartIndex * 8L, firstPieceSize);
                            Vect.memcpy(newAddress + firstPieceSize, oldAddress, this.dequeStartIndex * 8L);
                            this.dequeStartIndex = 0L;
                        }
                        this.dequeStartOffset = newAddress - this.dequeMemory.getPageAddress(0);
                        this.dequeEndIndex = this.dequeStartIndex + this.dequeCapacity;
                        this.dequeCapacity <<= 1;
                    }
                    this.dequeMemory.putDouble(this.dequeStartOffset + this.dequeEndIndex % this.dequeCapacity * 8L, value);
                    ++this.dequeEndIndex;
                    ++this.frameSize;
                }
                this.maxMin = this.dequeStartIndex == this.dequeEndIndex ? Double.NaN : this.dequeMemory.getDouble(this.dequeStartOffset + this.dequeStartIndex % this.dequeCapacity * 8L);
            } else {
                newFirstIdx = this.firstIdx;
                n = this.size;
                for (i = 0L; i < n && Math.abs(timestamp - (ts = this.memory.getLong(this.startOffset + (idx = (this.firstIdx + i) % this.capacity) * 16L))) >= this.minDiff; ++i) {
                    val = this.memory.getDouble(this.startOffset + idx * 16L + 8L);
                    if (Numbers.isNull(this.maxMin) || this.comparator.compare(val, this.maxMin)) {
                        this.maxMin = val;
                    }
                    ++this.frameSize;
                    newFirstIdx = (idx + 1L) % this.capacity;
                    --this.size;
                }
                this.firstIdx = newFirstIdx;
            }
        }

        @Override
        public double getDouble(Record rec) {
            return this.maxMin;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reopen() {
            this.maxMin = Double.NaN;
            this.capacity = this.initialCapacity;
            this.startOffset = this.memory.appendAddressFor(this.capacity * 16L) - this.memory.getPageAddress(0);
            this.firstIdx = 0L;
            this.frameSize = 0L;
            this.size = 0L;
            if (this.dequeMemory != null) {
                this.dequeCapacity = this.initialCapacity;
                this.dequeStartOffset = this.dequeMemory.appendAddressFor(this.dequeCapacity * 8L) - this.dequeMemory.getPageAddress(0);
                this.dequeStartIndex = 0L;
                this.dequeEndIndex = 0L;
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.memory.close();
            if (this.dequeMemory != null) {
                this.dequeMemory.close();
            }
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            sink.val(" over (");
            sink.val("range between ");
            if (this.frameLoBounded) {
                sink.val(this.maxDiff);
            } else {
                sink.val("unbounded");
            }
            sink.val(" preceding and ");
            if (this.minDiff == 0L) {
                sink.val("current row");
            } else {
                sink.val(this.minDiff).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.maxMin = Double.NaN;
            this.capacity = this.initialCapacity;
            this.memory.truncate();
            this.startOffset = this.memory.appendAddressFor(this.capacity * 16L) - this.memory.getPageAddress(0);
            this.firstIdx = 0L;
            this.frameSize = 0L;
            this.size = 0L;
            if (this.dequeMemory != null) {
                this.dequeMemory.truncate();
                this.dequeCapacity = this.initialCapacity;
                this.dequeStartOffset = this.dequeMemory.appendAddressFor(this.dequeCapacity * 8L) - this.dequeMemory.getPageAddress(0);
                this.dequeEndIndex = 0L;
                this.dequeStartIndex = 0L;
            }
        }
    }

    public static class MaxMinOverRowsFrameFunction
    extends BaseWindowFunction
    implements Reopenable,
    WindowDoubleFunction {
        private final MemoryARW buffer;
        private final int bufferSize;
        private final DoubleComparator comparator;
        private final boolean frameIncludesCurrentValue;
        private final boolean frameLoBounded;
        private final int frameSize;
        private final String name;
        private long dequeBufferSize;
        private long dequeEndIndex = 0L;
        private MemoryARW dequeMemory;
        private long dequeStartIndex = 0L;
        private int loIdx = 0;
        private double maxMin = Double.NaN;

        public MaxMinOverRowsFrameFunction(Function arg, long rowsLo, long rowsHi, MemoryARW memory, MemoryARW dequeMemory, DoubleComparator comparator, String name) {
            super(arg);
            assert (rowsLo != Long.MIN_VALUE || rowsHi != 0L);
            if (rowsLo > Long.MIN_VALUE) {
                this.frameSize = (int)(rowsHi - rowsLo + (long)(rowsHi < 0L ? 1 : 0));
                this.bufferSize = (int)Math.abs(rowsLo);
                this.frameLoBounded = true;
            } else {
                this.bufferSize = this.frameSize = (int)Math.abs(rowsHi);
                this.frameLoBounded = false;
            }
            this.frameIncludesCurrentValue = rowsHi == 0L;
            this.buffer = memory;
            try {
                this.initBuffer();
            }
            catch (Throwable t) {
                this.close();
                throw t;
            }
            if (this.frameLoBounded) {
                this.dequeMemory = dequeMemory;
                this.dequeBufferSize = rowsHi - rowsLo + 1L;
            }
            this.comparator = comparator;
            this.name = name;
        }

        @Override
        public void close() {
            super.close();
            this.buffer.close();
            if (this.dequeMemory != null) {
                this.dequeMemory.close();
            }
        }

        @Override
        public void computeNext(Record record) {
            double d;
            double hiValue = d = this.arg.getDouble(record);
            if (this.frameLoBounded && !this.frameIncludesCurrentValue) {
                hiValue = this.buffer.getDouble((long)((this.loIdx + this.frameSize - 1) % this.bufferSize) * 8L);
            } else if (!this.frameLoBounded && !this.frameIncludesCurrentValue) {
                hiValue = this.buffer.getDouble((long)(this.loIdx % this.bufferSize) * 8L);
            }
            if (Numbers.isFinite(hiValue)) {
                if (this.frameLoBounded) {
                    while (this.dequeStartIndex != this.dequeEndIndex && this.comparator.compare(hiValue, this.dequeMemory.getDouble((this.dequeEndIndex - 1L) % this.dequeBufferSize * 8L))) {
                        --this.dequeEndIndex;
                    }
                    this.dequeMemory.putDouble(this.dequeEndIndex % this.dequeBufferSize * 8L, hiValue);
                    ++this.dequeEndIndex;
                } else if (Numbers.isNull(this.maxMin) || this.comparator.compare(hiValue, this.maxMin)) {
                    this.maxMin = hiValue;
                }
            }
            if (this.frameLoBounded) {
                this.maxMin = this.dequeEndIndex == this.dequeStartIndex ? Double.NaN : this.dequeMemory.getDouble(this.dequeStartIndex % this.dequeBufferSize * 8L);
                double loValue = this.buffer.getDouble((long)this.loIdx * 8L);
                if (Numbers.isFinite(loValue) && this.dequeStartIndex != this.dequeEndIndex && loValue == this.dequeMemory.getDouble(this.dequeStartIndex % this.dequeBufferSize * 8L)) {
                    ++this.dequeStartIndex;
                }
            }
            this.buffer.putDouble((long)this.loIdx * 8L, d);
            this.loIdx = (this.loIdx + 1) % this.bufferSize;
        }

        @Override
        public double getDouble(Record rec) {
            return this.maxMin;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.maxMin);
        }

        @Override
        public void reopen() {
            this.maxMin = Double.NaN;
            this.loIdx = 0;
            this.initBuffer();
            if (this.dequeMemory != null) {
                this.dequeEndIndex = 0L;
                this.dequeStartIndex = 0L;
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.buffer.close();
            if (this.dequeMemory != null) {
                this.dequeMemory.close();
                this.dequeEndIndex = 0L;
                this.dequeStartIndex = 0L;
            }
            this.loIdx = 0;
            this.maxMin = Double.NaN;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            sink.val(" over (");
            sink.val(" rows between ");
            if (this.frameLoBounded) {
                sink.val(this.bufferSize);
            } else {
                sink.val("unbounded");
            }
            sink.val(" preceding and ");
            if (this.frameIncludesCurrentValue) {
                sink.val("current row");
            } else {
                sink.val(this.bufferSize - this.frameSize).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.maxMin = Double.NaN;
            this.loIdx = 0;
            this.initBuffer();
            if (this.dequeMemory != null) {
                this.dequeEndIndex = 0L;
                this.dequeStartIndex = 0L;
            }
        }

        private void initBuffer() {
            for (int i = 0; i < this.bufferSize; ++i) {
                this.buffer.putDouble((long)i * 8L, Double.NaN);
            }
        }
    }
}

