/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.TernaryFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;
import org.jetbrains.annotations.NotNull;

public class ReplaceStrFunctionFactory
implements FunctionFactory {
    private static final String SIGNATURE = "replace(SSS)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        int len;
        Function value;
        Function withWhat = args.getQuick(2);
        if (withWhat.isConstant() && withWhat.getStrLen(null) < 0) {
            return StrConstant.NULL;
        }
        Function term = args.getQuick(1);
        if (term.isConstant()) {
            if (term.getStrLen(null) < 0) {
                return StrConstant.NULL;
            }
            if (term.getStrLen(null) == 0) {
                return args.getQuick(0);
            }
        }
        if ((value = args.getQuick(0)).isConstant() && (len = value.getStrLen(null)) < 1) {
            return value;
        }
        int maxLength = configuration.getStrFunctionMaxBufferLength();
        return new Func(value, term, withWhat, maxLength);
    }

    private static class Func
    extends StrFunction
    implements TernaryFunction {
        private final int maxLength;
        private final Function newSubStr;
        private final Function oldSubStr;
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();
        private final Function value;

        public Func(Function value, Function oldSubStr, Function newSubStr, int maxLength) {
            this.value = value;
            this.oldSubStr = oldSubStr;
            this.newSubStr = newSubStr;
            this.maxLength = maxLength;
        }

        @Override
        public Function getCenter() {
            return this.oldSubStr;
        }

        @Override
        public Function getLeft() {
            return this.value;
        }

        @Override
        public Function getRight() {
            return this.newSubStr;
        }

        @Override
        public CharSequence getStrA(Record rec) {
            CharSequence value = this.value.getStrA(rec);
            if (value != null) {
                this.sinkA.clear();
                return (CharSequence)((Object)this.replace(value, this.oldSubStr.getStrA(rec), this.newSubStr.getStrA(rec), this.sinkA));
            }
            return null;
        }

        @Override
        public CharSequence getStrB(Record rec) {
            CharSequence value = this.value.getStrB(rec);
            if (value != null) {
                this.sinkB.clear();
                return (CharSequence)((Object)this.replace(value, this.oldSubStr.getStrB(rec), this.newSubStr.getStrB(rec), this.sinkB));
            }
            return null;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("replace(").val(this.value).val(',').val(this.oldSubStr).val(',').val(this.newSubStr).val(')');
        }

        private void checkLengthLimit(int length) {
            if (length > this.maxLength) {
                throw CairoException.nonCritical().put("breached memory limit set for ").put(ReplaceStrFunctionFactory.SIGNATURE).put(" [maxLength=").put(this.maxLength).put(", requiredLength=").put(length).put(']');
            }
        }

        private Utf16Sink replace(@NotNull CharSequence value, CharSequence term, CharSequence withWhat, Utf16Sink sink) throws CairoException {
            int valueLen = value.length();
            if (valueLen < 1) {
                return sink;
            }
            if (term == null || withWhat == null) {
                return null;
            }
            this.checkLengthLimit(valueLen);
            int termLen = term.length();
            if (termLen < 1) {
                sink.put(value);
                return sink;
            }
            int replLen = withWhat.length();
            int curLen = 0;
            block0: for (int i = 0; i < valueLen; ++i) {
                char c = value.charAt(i);
                if (c == term.charAt(0)) {
                    if (valueLen - i < termLen) {
                        this.checkLengthLimit(++curLen);
                        sink.put(value, i, valueLen);
                        break;
                    }
                    for (int k = 1; k < termLen; ++k) {
                        if (value.charAt(i + k) == term.charAt(k)) continue;
                        this.checkLengthLimit(++curLen);
                        sink.put(c);
                        continue block0;
                    }
                    this.checkLengthLimit(curLen += replLen);
                    sink.put(withWhat);
                    i += termLen - 1;
                    continue;
                }
                this.checkLengthLimit(++curLen);
                sink.put(c);
            }
            return sink;
        }
    }
}

