/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.lt;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;

public class LtTimestampCursorFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "<(NC)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        RecordCursorFactory factory = args.getQuick(1).getRecordCursorFactory();
        RecordMetadata metadata = factory.getMetadata();
        if (metadata.getColumnCount() != 1) {
            throw SqlException.$(argPositions.getQuick(1), "select must provide exactly one column");
        }
        switch (metadata.getColumnType(0)) {
            case 8: 
            case 33: {
                return new TimestampCursorFunc(factory, args.getQuick(0), args.getQuick(1));
            }
            case 11: {
                return new StrCursorFunc(factory, args.getQuick(0), args.getQuick(1), argPositions.getQuick(1));
            }
            case 26: {
                return new VarcharCursorFunc(factory, args.getQuick(0), args.getQuick(1), argPositions.getQuick(1));
            }
        }
        throw SqlException.$(argPositions.getQuick(1), "cannot compare TIMESTAMP and ").put(ColumnType.nameOf(metadata.getColumnType(0)));
    }

    private static class TimestampCursorFunc
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final RecordCursorFactory factory;
        private final Function leftFunc;
        private final Function rightFunc;
        private long epoch;
        private boolean stateInherited = false;
        private boolean stateShared = false;

        public TimestampCursorFunc(RecordCursorFactory factory, Function leftFunc, Function rightFunc) {
            this.factory = factory;
            this.leftFunc = leftFunc;
            this.rightFunc = rightFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            return Numbers.lessThan(this.leftFunc.getTimestamp(rec), this.epoch, this.negated);
        }

        @Override
        public Function getLeft() {
            return this.leftFunc;
        }

        @Override
        public Function getRight() {
            return this.rightFunc;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            BinaryFunction.super.init(symbolTableSource, executionContext);
            if (this.stateInherited) {
                return;
            }
            this.stateShared = false;
            try (RecordCursor cursor = this.factory.getCursor(executionContext);){
                this.epoch = cursor.hasNext() ? cursor.getRecord().getTimestamp(0) : Long.MIN_VALUE;
            }
        }

        @Override
        public boolean isThreadSafe() {
            return this.leftFunc.isThreadSafe();
        }

        @Override
        public void offerStateTo(Function that) {
            if (that instanceof TimestampCursorFunc) {
                TimestampCursorFunc thatF = (TimestampCursorFunc)that;
                thatF.epoch = this.epoch;
                this.stateShared = true;
                thatF.stateInherited = true;
            }
            BinaryFunction.super.offerStateTo(that);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.leftFunc);
            if (this.leftFunc.isThreadSafe()) {
                sink.val(" [thread-safe]");
            }
            if (this.negated) {
                sink.val(" >= ");
            } else {
                sink.val(" < ");
            }
            sink.val(this.rightFunc);
            if (this.stateShared) {
                sink.val(" [state-shared]");
            }
        }
    }

    private static class StrCursorFunc
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final RecordCursorFactory factory;
        private final Function leftFunc;
        private final Function rightFunc;
        private final int rightPos;
        private long epoch;
        private boolean stateInherited = false;
        private boolean stateShared = false;

        public StrCursorFunc(RecordCursorFactory factory, Function leftFunc, Function rightFunc, int rightPos) {
            this.factory = factory;
            this.leftFunc = leftFunc;
            this.rightFunc = rightFunc;
            this.rightPos = rightPos;
        }

        @Override
        public boolean getBool(Record rec) {
            return Numbers.lessThan(this.leftFunc.getTimestamp(rec), this.epoch, this.negated);
        }

        @Override
        public Function getLeft() {
            return this.leftFunc;
        }

        @Override
        public Function getRight() {
            return this.rightFunc;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            block10: {
                BinaryFunction.super.init(symbolTableSource, executionContext);
                if (this.stateInherited) {
                    return;
                }
                this.stateShared = false;
                try (RecordCursor cursor = this.factory.getCursor(executionContext);){
                    if (cursor.hasNext()) {
                        CharSequence value = cursor.getRecord().getStrA(0);
                        try {
                            this.epoch = value != null ? IntervalUtils.parseFloorPartialTimestamp(value) : Long.MIN_VALUE;
                            break block10;
                        }
                        catch (NumericException e) {
                            throw SqlException.$(this.rightPos, "the cursor selected invalid timestamp value: ").put(value);
                        }
                    }
                    this.epoch = Long.MIN_VALUE;
                }
            }
        }

        @Override
        public boolean isThreadSafe() {
            return this.leftFunc.isThreadSafe();
        }

        @Override
        public void offerStateTo(Function that) {
            if (that instanceof StrCursorFunc) {
                StrCursorFunc thatF = (StrCursorFunc)that;
                thatF.epoch = this.epoch;
                this.stateShared = true;
                thatF.stateInherited = true;
            }
            BinaryFunction.super.offerStateTo(that);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.leftFunc);
            if (this.isThreadSafe()) {
                sink.val(" [thread-safe]");
            }
            if (this.negated) {
                sink.val(" >= ");
            } else {
                sink.val(" < ");
            }
            sink.val(this.rightFunc);
            if (this.stateShared) {
                sink.val(" [state-shared]");
            }
        }
    }

    private static class VarcharCursorFunc
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final RecordCursorFactory factory;
        private final Function leftFunc;
        private final Function rightFunc;
        private final int rightPos;
        private long epoch;
        private boolean stateInherited = false;
        private boolean stateShared = false;

        public VarcharCursorFunc(RecordCursorFactory factory, Function leftFunc, Function rightFunc, int rightPos) {
            this.factory = factory;
            this.leftFunc = leftFunc;
            this.rightFunc = rightFunc;
            this.rightPos = rightPos;
        }

        @Override
        public boolean getBool(Record rec) {
            return Numbers.lessThan(this.leftFunc.getTimestamp(rec), this.epoch, this.negated);
        }

        @Override
        public Function getLeft() {
            return this.leftFunc;
        }

        @Override
        public Function getRight() {
            return this.rightFunc;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            block10: {
                BinaryFunction.super.init(symbolTableSource, executionContext);
                if (this.stateInherited) {
                    return;
                }
                this.stateShared = false;
                try (RecordCursor cursor = this.factory.getCursor(executionContext);){
                    if (cursor.hasNext()) {
                        Utf8Sequence value = cursor.getRecord().getVarcharA(0);
                        try {
                            this.epoch = value != null ? IntervalUtils.parseFloorPartialTimestamp(value) : Long.MIN_VALUE;
                            break block10;
                        }
                        catch (NumericException e) {
                            throw SqlException.$(this.rightPos, "the cursor selected invalid timestamp value: ").put(value);
                        }
                    }
                    this.epoch = Long.MIN_VALUE;
                }
            }
        }

        @Override
        public boolean isThreadSafe() {
            return this.leftFunc.isThreadSafe();
        }

        @Override
        public void offerStateTo(Function that) {
            if (that instanceof VarcharCursorFunc) {
                VarcharCursorFunc thatF = (VarcharCursorFunc)that;
                thatF.epoch = this.epoch;
                this.stateShared = true;
                thatF.stateInherited = true;
            }
            BinaryFunction.super.offerStateTo(that);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.leftFunc);
            if (this.leftFunc.isThreadSafe()) {
                sink.val(" [thread-safe]");
            }
            if (this.negated) {
                sink.val(" >= ");
            } else {
                sink.val(" < ");
            }
            sink.val(this.rightFunc);
            if (this.stateShared) {
                sink.val(" [state-shared]");
            }
        }
    }
}

