/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Numbers;
import org.jetbrains.annotations.NotNull;

public class MaxDoubleGroupByFunction
extends DoubleFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public MaxDoubleGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        mapValue.putDouble(this.valueIndex, this.arg.getDouble(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        double max = mapValue.getDouble(this.valueIndex);
        double next = this.arg.getDouble(record);
        if (next > max || Numbers.isNull(max)) {
            mapValue.putDouble(this.valueIndex, next);
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public double getDouble(Record rec) {
        return rec.getDouble(this.valueIndex);
    }

    @Override
    public String getName() {
        return "max";
    }

    @Override
    public int getSampleByFlags() {
        return 31;
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(10);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return UnaryFunction.super.isThreadSafe();
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        double destMax;
        double srcMax = srcValue.getDouble(this.valueIndex);
        if (srcMax > (destMax = destValue.getDouble(this.valueIndex)) || Numbers.isNull(destMax)) {
            destValue.putDouble(this.valueIndex, srcMax);
        }
    }

    @Override
    public void setDouble(MapValue mapValue, double value) {
        mapValue.putDouble(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putDouble(this.valueIndex, Double.NaN);
    }

    @Override
    public boolean supportsParallelism() {
        return UnaryFunction.super.supportsParallelism();
    }
}

