/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.groupby.FirstDoubleGroupByFunction;
import io.questdb.std.Numbers;
import org.jetbrains.annotations.NotNull;

public class FirstNotNullDoubleGroupByFunction
extends FirstDoubleGroupByFunction {
    public FirstNotNullDoubleGroupByFunction(@NotNull Function arg) {
        super(arg);
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        if (Numbers.isNull(mapValue.getDouble(this.valueIndex + 1))) {
            this.computeFirst(mapValue, record, rowId);
        }
    }

    @Override
    public String getName() {
        return "first_not_null";
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        long destRowId;
        long srcRowId;
        double srcVal = srcValue.getDouble(this.valueIndex + 1);
        if (Numbers.isFinite(srcVal) && ((srcRowId = srcValue.getLong(this.valueIndex)) < (destRowId = destValue.getLong(this.valueIndex)) || destRowId == Long.MIN_VALUE)) {
            destValue.putLong(this.valueIndex, srcRowId);
            destValue.putDouble(this.valueIndex + 1, srcVal);
        }
    }
}

