/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.arr.ArrayTypeDriver;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.BorrowedArray;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.ArrayFunction;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.ArrayConstant;
import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;

public class FirstArrayGroupByFunction
extends ArrayFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private final BorrowedArray borrowedArray = new BorrowedArray();
    private GroupByAllocator allocator;
    private int valueIndex;

    public FirstArrayGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
        this.type = arg.getType();
    }

    @Override
    public void clear() {
    }

    @Override
    public void close() {
        Misc.free(this.arg);
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        mapValue.putLong(this.valueIndex, rowId);
        ArrayView val = this.arg.getArray(record);
        if (val == null || val.isNull()) {
            mapValue.putLong(this.valueIndex + 1, -1L);
        } else {
            long size = ArrayTypeDriver.getPlainValueSize(val);
            long ptr = this.allocator.malloc(size);
            ArrayTypeDriver.appendPlainValue(ptr, val);
            mapValue.putLong(this.valueIndex + 1, ptr);
        }
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public ArrayView getArray(Record rec) {
        long ptr = rec.getLong(this.valueIndex + 1);
        if (ptr < 0L) {
            return ArrayConstant.NULL;
        }
        return ArrayTypeDriver.getPlainValue(ptr, this.borrowedArray);
    }

    @Override
    public String getName() {
        return "first";
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(6);
        columnTypes.add(6);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isScalar() {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        long srcRowId = srcValue.getLong(this.valueIndex);
        long destRowId = destValue.getLong(this.valueIndex);
        if (srcRowId != Long.MIN_VALUE && (srcRowId < destRowId || destRowId == Long.MIN_VALUE)) {
            destValue.putLong(this.valueIndex, srcRowId);
            destValue.putLong(this.valueIndex + 1, srcValue.getLong(this.valueIndex + 1));
        }
    }

    @Override
    public void setAllocator(GroupByAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putLong(this.valueIndex, Long.MIN_VALUE);
        mapValue.putLong(this.valueIndex + 1, -1L);
    }

    @Override
    public boolean supportsParallelism() {
        return true;
    }

    @Override
    public void toTop() {
        UnaryFunction.super.toTop();
    }
}

