/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.groupby.ApproxCountDistinctIntGroupByFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class ApproxCountDistinctIntGroupByFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "approx_count_distinct(Ii)";
    }

    @Override
    public boolean isGroupBy() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function exprFunc = args.getQuick(0);
        Function precisionFunc = args.getQuick(1);
        if (!precisionFunc.isConstant()) {
            throw SqlException.$(argPositions.getQuick(1), "precision must be a constant");
        }
        int precision = precisionFunc.getInt(null);
        if (precision < 4 || precision > 18) {
            throw SqlException.$(position, "precision must be between 4 and 18");
        }
        return new ApproxCountDistinctIntGroupByFunction(exprFunc, precision);
    }
}

