/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class EqIntStrCFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(Is)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        try {
            CharSequence value = args.getQuick(1).getStrA(null);
            if (value == null) {
                return new Func(args.getQuick(0), Integer.MIN_VALUE);
            }
            return new Func(args.getQuick(0), Numbers.parseInt(value));
        }
        catch (NumericException e) {
            return new NegatedAwareBooleanConstantFunc();
        }
    }

    private static class Func
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function left;
        private final int right;

        public Func(Function left, int right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public Function getArg() {
            return this.left;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.left.getInt(rec) == this.right);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.left);
            if (this.negated) {
                sink.val('!');
            }
            sink.val('=');
            if (this.right != Integer.MIN_VALUE) {
                sink.val(this.right);
            } else {
                sink.val("null");
            }
        }
    }

    private static class NegatedAwareBooleanConstantFunc
    extends NegatableBooleanFunction
    implements ConstantFunction {
        private NegatedAwareBooleanConstantFunc() {
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.negated);
        }
    }
}

