/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class DoubleArrayMaxFunctionFactory
implements FunctionFactory {
    private static final String FUNCTION_NAME = "array_max";

    @Override
    public String getSignature() {
        return "array_max(D[])";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return new Func(args.getQuick(0));
    }

    static class Func
    extends DoubleFunction
    implements UnaryFunction {
        private final Function arrayArg;

        Func(Function arrayArg) {
            this.arrayArg = arrayArg;
        }

        @Override
        public Function getArg() {
            return this.arrayArg;
        }

        @Override
        public double getDouble(Record rec) {
            ArrayView view = this.arrayArg.getArray(rec);
            if (view.isNull()) {
                return Double.NaN;
            }
            if (view.isVanilla()) {
                return view.flatView().maxDouble(view.getFlatViewOffset(), view.getFlatViewLength());
            }
            return Func.calculateRecursive(view, 0, 0, Double.NEGATIVE_INFINITY);
        }

        @Override
        public String getName() {
            return DoubleArrayMaxFunctionFactory.FUNCTION_NAME;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        private static double calculateRecursive(ArrayView view, int dim, int flatIndex, double max) {
            boolean atDeepestDim;
            int count = view.getDimLen(dim);
            int stride = view.getStride(dim);
            boolean bl = atDeepestDim = dim == view.getDimCount() - 1;
            if (atDeepestDim) {
                for (int i = 0; i < count; ++i) {
                    double v = view.getDouble(flatIndex);
                    if (Numbers.isFinite(v) && v > max) {
                        max = v;
                    }
                    flatIndex += stride;
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    max = Func.calculateRecursive(view, dim + 1, flatIndex, max);
                    flatIndex += stride;
                }
            }
            return max;
        }
    }
}

