/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.text.Utf8Exception;
import io.questdb.cutlass.text.types.AbstractTypeAdapter;
import io.questdb.std.str.DirectUtf16Sink;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.DirectUtf8Sink;
import io.questdb.std.str.Utf8s;

public class SymbolAdapter
extends AbstractTypeAdapter {
    private final boolean indexed;
    private final DirectUtf16Sink utf16Sink;

    public SymbolAdapter(DirectUtf16Sink utf16Sink, boolean indexed) {
        this.utf16Sink = utf16Sink;
        this.indexed = indexed;
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public boolean isIndexed() {
        return this.indexed;
    }

    @Override
    public boolean probe(DirectUtf8Sequence text) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectUtf8Sequence value) throws Exception {
        this.write(row, column, value, this.utf16Sink, null);
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectUtf8Sequence value, DirectUtf16Sink utf16Sink, DirectUtf8Sink utf8Sink) throws Exception {
        utf16Sink.clear();
        if (!Utf8s.utf8ToUtf16EscConsecutiveQuotes(value.lo(), value.hi(), utf16Sink)) {
            throw Utf8Exception.INSTANCE;
        }
        row.putSym(column, utf16Sink);
    }
}

