/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.sql.Record;
import io.questdb.cutlass.pgwire.PGMessageProcessingException;
import io.questdb.cutlass.pgwire.PGPipelineEntry;
import io.questdb.std.BinarySequence;
import io.questdb.std.Chars;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Numbers;
import io.questdb.std.Uuid;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;

class PGUtils {
    private static final int MAX_BYTE_TEXT_LEN = String.valueOf(-128).length();
    private static final int MAX_CHAR_TEXT_LEN = 3;
    private static final int MAX_DATE_TEXT_LEN = 28;
    private static final int MAX_DOUBLE_TEXT_LEN = 24;
    private static final int MAX_FLOAT_TEXT_LEN = 16;
    private static final int MAX_GEOBYTE_TEXT_LEN = 8;
    private static final int MAX_GEOINT_TEXT_LEN = 32;
    private static final int MAX_GEOLONG_TEXT_LEN = 64;
    private static final int MAX_GEOSHORT_TEXT_LEN = 16;
    private static final int MAX_INT_TEXT_LEN = String.valueOf(Integer.MIN_VALUE).length();
    private static final int MAX_IPv4_TEXT_LEN = 15;
    private static final int MAX_LONG256_TEXT_LEN = 66;
    private static final int MAX_LONG_TEXT_LEN = String.valueOf(Long.MIN_VALUE).length();
    private static final int MAX_SHORT_TEXT_LEN = String.valueOf(Short.MIN_VALUE).length();
    private static final int MAX_TIMESTAMP_TEXT_LEN = 28;
    private static final int MAX_UUID_TEXT_LEN = 36;

    private PGUtils() {
    }

    public static int calculateArrayColBinSize(ArrayView array, int notNullCount) {
        int headerSize = 16 + array.getDimCount() * 8;
        return headerSize + notNullCount * 12 + (array.getCardinality() - notNullCount) * 4;
    }

    public static int calculateArrayResumeColBinSize(int notNullCount, int nullCount) {
        return notNullCount * 12 + nullCount * 4;
    }

    public static int calculateColumnBinSize(PGPipelineEntry pipelineEntry, Record record, int columnIndex, int columnType, int geohashSize, long maxBlobSize, int arrayResumePoint) throws PGMessageProcessingException {
        short typeTag = ColumnType.tagOf(columnType);
        switch (typeTag) {
            case 33: {
                return 4;
            }
            case 1: {
                return 5;
            }
            case 2: 
            case 3: {
                return 6;
            }
            case 4: {
                char charValue = record.getChar(columnIndex);
                return charValue == '\u0000' ? 4 : 4 + Chars.charBytes(charValue);
            }
            case 25: {
                int ipValue = record.getIPv4(columnIndex);
                return ipValue != 0 ? 4 + Numbers.sinkSizeIPv4(ipValue) : 4;
            }
            case 5: {
                int value = record.getInt(columnIndex);
                return value != Integer.MIN_VALUE ? 8 : 4;
            }
            case 6: {
                long longValue = record.getLong(columnIndex);
                return longValue != Long.MIN_VALUE ? 12 : 4;
            }
            case 7: {
                long dateValue = record.getDate(columnIndex);
                return dateValue != Long.MIN_VALUE ? 12 : 4;
            }
            case 8: {
                long tsValue = record.getTimestamp(columnIndex);
                return tsValue != Long.MIN_VALUE ? 12 : 4;
            }
            case 9: {
                float floatValue = record.getFloat(columnIndex);
                return Float.isNaN(floatValue) ? 4 : 8;
            }
            case 10: {
                double doubleValue = record.getDouble(columnIndex);
                return Double.isNaN(doubleValue) ? 4 : 12;
            }
            case 19: {
                long lo = record.getLong128Lo(columnIndex);
                long hi = record.getLong128Hi(columnIndex);
                return Uuid.isNull(lo, hi) ? 4 : 20;
            }
            case 13: {
                Long256 long256Value = record.getLong256A(columnIndex);
                return Long256Impl.isNull(long256Value) ? 4 : 4 + Numbers.hexDigitsLong256(long256Value);
            }
            case 14: {
                return PGUtils.geoHashBytes(record.getGeoByte(columnIndex), geohashSize);
            }
            case 15: {
                return PGUtils.geoHashBytes(record.getGeoShort(columnIndex), geohashSize);
            }
            case 16: {
                return PGUtils.geoHashBytes(record.getGeoInt(columnIndex), geohashSize);
            }
            case 17: {
                return PGUtils.geoHashBytes(record.getGeoLong(columnIndex), geohashSize);
            }
            case 26: {
                Utf8Sequence vcValue = record.getVarcharA(columnIndex);
                return vcValue == null ? 4 : 4 + vcValue.size();
            }
            case 11: {
                CharSequence strValue = record.getStrA(columnIndex);
                return strValue == null ? 4 : 4 + Utf8s.utf8Bytes(strValue);
            }
            case 12: {
                CharSequence symValue = record.getSymA(columnIndex);
                return symValue == null ? 4 : 4 + Utf8s.utf8Bytes(symValue);
            }
            case 18: {
                BinarySequence sequence = record.getBin(columnIndex);
                if (sequence == null) {
                    return 4;
                }
                long blobSize = sequence.length();
                if (blobSize < maxBlobSize) {
                    return 4 + (int)blobSize;
                }
                throw PGMessageProcessingException.instance(pipelineEntry).put("blob is too large [blobSize=").put(blobSize).put(", maxBlobSize=").put(maxBlobSize).put(", columnIndex=").put(columnIndex).put(']');
            }
            case 27: {
                ArrayView array = record.getArray(columnIndex, columnType);
                if (array.isNull()) {
                    return 4;
                }
                assert (ColumnType.decodeArrayElementType(columnType) == 10 || ColumnType.decodeArrayElementType(columnType) == 6) : "implemented only for DOUBLE and LONG";
                int notNullCount = PGUtils.countNotNull(array, arrayResumePoint);
                return PGUtils.calculateArrayResumeColBinSize(notNullCount, array.getCardinality() - notNullCount);
            }
        }
        assert (false) : "unsupported type: " + typeTag;
        return -1;
    }

    public static int countNotNull(ArrayView array, int resumePoint) {
        if (array.isVanilla()) {
            switch (array.getElemType()) {
                case 10: {
                    return array.flatView().countDouble(array.getFlatViewOffset() + resumePoint, array.getFlatViewLength() - resumePoint);
                }
                case 6: {
                    return array.flatView().countLong(array.getFlatViewOffset() + resumePoint, array.getFlatViewLength() - resumePoint);
                }
            }
            throw new AssertionError((Object)("Unsupported array element type: " + array.getElemType()));
        }
        return PGUtils.countNotNullRecursive(array, 0, 0, resumePoint);
    }

    public static long estimateColumnTxtSize(Record record, int columnIndex, int typeTag) {
        switch (typeTag) {
            case 33: {
                return 4L;
            }
            case 1: {
                return 5L;
            }
            case 2: {
                return 4 + MAX_BYTE_TEXT_LEN;
            }
            case 3: {
                return 4 + MAX_SHORT_TEXT_LEN;
            }
            case 4: {
                return 7L;
            }
            case 25: {
                return 19L;
            }
            case 5: {
                return 4 + MAX_INT_TEXT_LEN;
            }
            case 6: {
                return 4 + MAX_LONG_TEXT_LEN;
            }
            case 7: {
                return 32L;
            }
            case 8: {
                return 32L;
            }
            case 9: {
                return 20L;
            }
            case 10: {
                return 28L;
            }
            case 19: {
                return 40L;
            }
            case 13: {
                return 70L;
            }
            case 14: {
                return 12L;
            }
            case 15: {
                return 20L;
            }
            case 16: {
                return 36L;
            }
            case 17: {
                return 68L;
            }
            case 26: {
                Utf8Sequence vcValue = record.getVarcharA(columnIndex);
                return vcValue == null ? 4L : (long)(4 + vcValue.size());
            }
            case 11: {
                CharSequence strValue = record.getStrA(columnIndex);
                return strValue == null ? 4L : 4L + 3L * (long)strValue.length();
            }
            case 12: {
                CharSequence symValue = record.getSymA(columnIndex);
                return symValue == null ? 4L : 4L + 3L * (long)symValue.length();
            }
            case 18: {
                BinarySequence sequence = record.getBin(columnIndex);
                return sequence == null ? 4L : 4L + sequence.length();
            }
        }
        assert (false) : "unsupported type: " + typeTag;
        return -1L;
    }

    private static int countNotNullRecursive(ArrayView array, int dim, int flatIndex, int resumePoint) {
        boolean atDeepestDim;
        int count = 0;
        int dimLen = array.getDimLen(dim);
        int stride = array.getStride(dim);
        boolean bl = atDeepestDim = dim == array.getDimCount() - 1;
        if (atDeepestDim) {
            short elemType = array.getElemType();
            for (int i = 0; i < dimLen; ++i) {
                if (flatIndex >= resumePoint) {
                    switch (elemType) {
                        case 10: {
                            if (!Numbers.isFinite(array.getDouble(flatIndex))) break;
                            ++count;
                            break;
                        }
                        case 6: {
                            if (array.getLong(flatIndex) == Long.MIN_VALUE) break;
                            ++count;
                        }
                    }
                }
                flatIndex += stride;
            }
        } else {
            for (int i = 0; i < dimLen; ++i) {
                count += PGUtils.countNotNullRecursive(array, dim + 1, flatIndex, resumePoint);
                flatIndex += stride;
            }
        }
        return count;
    }

    private static int geoHashBytes(long value, int size) {
        if (value == -1L) {
            return 4;
        }
        assert (size > 0);
        return 4 + size;
    }
}

