/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.pgwire;

import io.questdb.cutlass.pgwire.PGPipelineEntry;
import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.ThreadLocal;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PGMessageProcessingException
extends Exception
implements FlyweightMessageContainer {
    public static final PGMessageProcessingException INSTANCE = new PGMessageProcessingException();
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private static final ThreadLocal<PGMessageProcessingException> tlException = new ThreadLocal<PGMessageProcessingException>(PGMessageProcessingException::new);
    private StringSink message;
    private PGPipelineEntry pe;

    public static PGMessageProcessingException instance(@NotNull PGPipelineEntry pe) {
        PGMessageProcessingException ex = tlException.get();
        assert ((ex = new PGMessageProcessingException()) != null);
        ex.message = pe.getErrorMessageSink();
        ex.pe = pe;
        return ex;
    }

    @Override
    public CharSequence getFlyweightMessage() {
        return this.message;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        StackTraceElement[] result = EMPTY_STACK_TRACE;
        assert ((result = super.getStackTrace()) != null);
        return result;
    }

    public PGMessageProcessingException put(Throwable e) {
        if (e instanceof FlyweightMessageContainer) {
            this.message.put(((FlyweightMessageContainer)((Object)e)).getFlyweightMessage());
            this.pe.setErrorMessagePosition(((FlyweightMessageContainer)((Object)e)).getPosition());
        } else {
            this.message.put(e.getMessage());
        }
        return this;
    }

    public PGMessageProcessingException put(long value) {
        this.message.put(value);
        return this;
    }

    public PGMessageProcessingException put(double value) {
        this.message.put(value);
        return this;
    }

    public PGMessageProcessingException put(@Nullable CharSequence cs) {
        this.message.put(cs);
        return this;
    }

    public PGMessageProcessingException put(@Nullable Utf8Sequence us) {
        this.message.put(us);
        return this;
    }

    public PGMessageProcessingException put(Sinkable sinkable) {
        sinkable.toSink(this.message);
        return this;
    }

    public PGMessageProcessingException put(char c) {
        this.message.put(c);
        return this;
    }

    public PGMessageProcessingException put(boolean value) {
        this.message.put(value);
        return this;
    }
}

