/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp.auth;

import io.questdb.cutlass.auth.AuthenticatorException;
import io.questdb.cutlass.auth.ChallengeResponseMatcher;
import io.questdb.cutlass.auth.SocketAuthenticator;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.Socket;
import io.questdb.std.ThreadLocal;
import io.questdb.std.Unsafe;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.Utf8s;
import java.security.SecureRandom;
import org.jetbrains.annotations.NotNull;

public class EllipticCurveAuthenticator
implements SocketAuthenticator {
    private static final Log LOG = LogFactory.getLog(EllipticCurveAuthenticator.class);
    private static final ThreadLocal<SecureRandom> tlSrand = new ThreadLocal<SecureRandom>(SecureRandom::new);
    private final ChallengeResponseMatcher challengeResponseMatcher;
    private final DirectUtf8String userNameFlyweight = new DirectUtf8String();
    protected long recvBufPseudoStart;
    private AuthState authState;
    private long challengePtr;
    private String principal;
    private long recvBufEnd;
    private long recvBufPos;
    private long recvBufStart;
    private Socket socket;

    public EllipticCurveAuthenticator(ChallengeResponseMatcher challengeResponseMatcher) {
        this.challengeResponseMatcher = challengeResponseMatcher;
        this.challengePtr = Unsafe.malloc(512L, 19);
    }

    @Override
    public void close() {
        this.challengePtr = Unsafe.free(this.challengePtr, 512L, 19);
    }

    @Override
    public byte getAuthType() {
        return 2;
    }

    @Override
    public CharSequence getPrincipal() {
        return this.principal;
    }

    @Override
    public long getRecvBufPos() {
        return this.recvBufPos;
    }

    @Override
    public long getRecvBufPseudoStart() {
        return this.recvBufPseudoStart;
    }

    @Override
    public int handleIO() throws AuthenticatorException {
        switch (this.authState) {
            case WAITING_FOR_KEY_ID: {
                this.readKeyId();
                if (this.authState != AuthState.SENDING_CHALLENGE) break;
            }
            case SENDING_CHALLENGE: {
                this.sendChallenge();
                break;
            }
            case WAITING_FOR_RESPONSE: {
                int p = this.waitForResponse();
                if (this.authState != AuthState.COMPLETE || this.recvBufPos <= this.recvBufStart) break;
                this.recvBufPseudoStart = this.recvBufStart + (long)p + 1L;
                break;
            }
        }
        return this.authState.ioContextResult;
    }

    @Override
    public void init(@NotNull Socket socket, long recvBuffer, long recvBufferLimit, long sendBuffer, long sendBufferLimit) {
        this.socket = socket;
        this.authState = AuthState.WAITING_FOR_KEY_ID;
        this.recvBufStart = recvBuffer;
        this.recvBufPos = recvBuffer;
        this.recvBufEnd = recvBufferLimit;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authState == AuthState.COMPLETE;
    }

    private int findLineEnd() throws AuthenticatorException {
        int bufferRemaining = (int)(this.recvBufEnd - this.recvBufPos);
        if (bufferRemaining > 0) {
            int bytesRead = this.socket.recv(this.recvBufPos, bufferRemaining);
            if (bytesRead > 0) {
                this.recvBufPos += (long)bytesRead;
            } else if (bytesRead < 0) {
                LOG.info().$('[').$(this.socket.getFd()).$("] authentication disconnected by peer when reading token").$();
                throw AuthenticatorException.INSTANCE;
            }
        }
        int len = (int)(this.recvBufPos - this.recvBufStart);
        int lineEnd = -1;
        for (int n = 0; n < len; ++n) {
            byte b = Unsafe.getUnsafe().getByte(this.recvBufStart + (long)n);
            if (b != 10) continue;
            lineEnd = n;
            break;
        }
        if (lineEnd != -1) {
            return lineEnd;
        }
        if (this.recvBufPos == this.recvBufEnd) {
            LOG.info().$('[').$(this.socket.getFd()).$("] authentication token is too long").$();
            throw AuthenticatorException.INSTANCE;
        }
        return lineEnd;
    }

    private void readKeyId() throws AuthenticatorException {
        int lineEnd = this.findLineEnd();
        if (lineEnd != -1) {
            int n;
            this.userNameFlyweight.of(this.recvBufStart, this.recvBufStart + (long)lineEnd);
            this.principal = Utf8s.toString(this.userNameFlyweight);
            LOG.info().$('[').$(this.socket.getFd()).$("] authentication read key id [keyId=").$(this.userNameFlyweight).I$();
            this.recvBufPos = this.recvBufStart;
            SecureRandom srand = tlSrand.get();
            for (n = 0; n < 512; ++n) {
                assert (this.recvBufStart + (long)n < this.recvBufEnd);
                int r = (int)(srand.nextDouble() * 95.0) + 32;
                Unsafe.getUnsafe().putByte(this.recvBufStart + (long)n, (byte)r);
                Unsafe.getUnsafe().putByte(this.challengePtr + (long)n, (byte)r);
            }
            Unsafe.getUnsafe().putByte(this.recvBufStart + (long)n, (byte)10);
            this.authState = AuthState.SENDING_CHALLENGE;
        }
    }

    private void sendChallenge() throws AuthenticatorException {
        int nWritten;
        int n = 513 - (int)(this.recvBufPos - this.recvBufStart);
        assert (n > 0);
        while ((nWritten = this.socket.send(this.recvBufPos, n)) > 0) {
            if (n == nWritten) {
                this.recvBufPos = this.recvBufStart;
                this.authState = AuthState.WAITING_FOR_RESPONSE;
                return;
            }
            this.recvBufPos += (long)nWritten;
        }
        if (nWritten == 0) {
            return;
        }
        LOG.info().$('[').$(this.socket.getFd()).$("] authentication peer disconnected when challenge was being sent").$();
        throw AuthenticatorException.INSTANCE;
    }

    private int waitForResponse() throws AuthenticatorException {
        int lineEnd = this.findLineEnd();
        if (lineEnd != -1) {
            if (lineEnd > 96) {
                LOG.info().$('[').$(this.socket.getFd()).$("] authentication signature is too long").$();
                throw AuthenticatorException.INSTANCE;
            }
            this.authState = AuthState.FAILED;
            boolean verified = this.challengeResponseMatcher.verifyJwk(this.principal, this.challengePtr, 512, this.recvBufStart, lineEnd);
            if (!verified) {
                LOG.info().$('[').$(this.socket.getFd()).$("] authentication failed, signature was not verified").$();
                throw AuthenticatorException.INSTANCE;
            }
            this.authState = AuthState.COMPLETE;
            LOG.info().$('[').$(this.socket.getFd()).$("] authentication success").$();
        }
        return lineEnd;
    }

    private static enum AuthState {
        WAITING_FOR_KEY_ID(0),
        SENDING_CHALLENGE(1),
        WAITING_FOR_RESPONSE(0),
        COMPLETE(-1),
        FAILED(3);

        private final int ioContextResult;

        private AuthState(int ioContextResult) {
            this.ioContextResult = ioContextResult;
        }
    }
}

