/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.vm;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.MemoryCMRImpl;
import io.questdb.cairo.vm.api.MemoryCMOR;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.LPSZ;

public class MemoryCMORImpl
extends MemoryCMRImpl
implements MemoryCMOR {
    private static final Log LOG = LogFactory.getLog(MemoryCMORImpl.class);
    private boolean closeFdOnClose = true;
    private long mapFileOffset;
    private long offset;

    @Override
    public long addressOf(long fileOffset) {
        assert (this.checkOffsetMapped(fileOffset)) : "offset=" + this.offset + ", size=" + this.size + ", fd=" + this.fd;
        if (this.pageAddress == 0L) {
            this.map(this.ff, this.size, this.mapFileOffset);
        }
        return this.pageAddress + fileOffset - this.mapFileOffset;
    }

    @Override
    public boolean checkOffsetMapped(long fileOffset) {
        return fileOffset - this.mapFileOffset <= this.size;
    }

    @Override
    public void close() {
        if (!this.closeFdOnClose) {
            this.fd = -1L;
        }
        super.close();
        this.mapFileOffset = 0L;
        this.offset = 0L;
        this.closeFdOnClose = true;
    }

    @Override
    public long detachFdClose() {
        long lfd = this.fd;
        this.fd = -1L;
        this.close();
        return lfd;
    }

    @Override
    public void extend(long newSize) {
        if (newSize > this.size) {
            this.setSize0(newSize + this.offset - this.mapFileOffset);
        }
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public void growToFileSize() {
        long length = this.getFilesFacade().length(this.getFd());
        if (length < 0L) {
            throw CairoException.critical(this.ff.errno()).put("could not get length fd: ").put(this.fd);
        }
        this.extend(length - this.mapFileOffset);
    }

    @Override
    public void map() {
        if (this.pageAddress == 0L) {
            this.map(this.ff, this.size, this.mapFileOffset);
        }
    }

    @Override
    public void of(FilesFacade ff, LPSZ name, long extendSegmentSize, long size, int memoryTag, int opts) {
        this.ofOffset(ff, name, 0L, size, memoryTag, opts);
    }

    @Override
    public void ofOffset(FilesFacade ff, long fd, boolean keepFdOpen, LPSZ name, long lo, long hi, int memoryTag, int opts) {
        this.memoryTag = memoryTag;
        if (fd > -1L) {
            this.close();
            this.closeFdOnClose = !keepFdOpen;
            this.ff = ff;
            this.fd = fd;
        } else {
            this.closeFdOnClose = !keepFdOpen;
            this.openFile(ff, name);
        }
        this.mapLazy(lo, hi);
    }

    @Override
    public long size() {
        return this.size + this.mapFileOffset - this.offset;
    }

    private void mapLazy(long lo, long hi) {
        assert (hi >= 0L && hi >= lo) : "hi : " + hi + " lo : " + lo;
        if (hi > lo) {
            this.offset = lo;
            this.mapFileOffset = Files.PAGE_SIZE * (lo / Files.PAGE_SIZE);
            this.size = hi - this.mapFileOffset;
        } else {
            this.size = 0L;
        }
    }

    private void openFile(FilesFacade ff, LPSZ name) {
        this.close();
        this.ff = ff;
        this.fd = TableUtils.openRO(ff, name, LOG);
    }

    private void setSize0(long newSize) {
        try {
            this.pageAddress = this.size > 0L && this.pageAddress != 0L ? TableUtils.mremap(this.ff, this.fd, this.pageAddress, this.size, newSize, this.mapFileOffset, 1, this.memoryTag) : TableUtils.mapRO(this.ff, this.fd, newSize, this.mapFileOffset, this.memoryTag);
            this.size = newSize;
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    protected void map(FilesFacade ff, long size, long mapOffset) {
        this.size = size;
        if (size > 0L) {
            try {
                this.pageAddress = TableUtils.mapRO(ff, this.fd, size, mapOffset, this.memoryTag);
            }
            catch (Throwable e) {
                this.close();
                throw e;
            }
        }
        LOG.debug().$("map  [fd=").$(this.fd).$(", size=").$(this.size).$(']').$();
    }
}

