/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SqlExecutionCircuitBreakerConfiguration;
import io.questdb.network.NetworkFacade;
import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.millitime.MillisecondClock;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class NetworkSqlExecutionCircuitBreaker
implements SqlExecutionCircuitBreaker,
Closeable,
Mutable {
    private final int bufferSize;
    private final MillisecondClock clock;
    private final SqlExecutionCircuitBreakerConfiguration configuration;
    private final long defaultMaxTime;
    private final int memoryTag;
    private final NetworkFacade nf;
    private final int throttle;
    private long buffer;
    private volatile AtomicBoolean cancelledFlag;
    private long fd = -1L;
    private volatile long powerUpTime = Long.MAX_VALUE;
    private int secret;
    private int testCount;
    private long timeout;

    public NetworkSqlExecutionCircuitBreaker(@NotNull SqlExecutionCircuitBreakerConfiguration configuration, int memoryTag) {
        this.configuration = configuration;
        this.nf = configuration.getNetworkFacade();
        this.throttle = configuration.getCircuitBreakerThrottle();
        this.bufferSize = configuration.getBufferSize();
        this.memoryTag = memoryTag;
        this.buffer = Unsafe.malloc(this.bufferSize, this.memoryTag);
        this.clock = configuration.getClock();
        long timeout = configuration.getQueryTimeout();
        this.timeout = timeout > 0L ? timeout : (timeout == Long.MIN_VALUE ? -100L : Long.MAX_VALUE);
        this.defaultMaxTime = this.timeout;
    }

    @Override
    public void cancel() {
        this.powerUpTime = Long.MIN_VALUE;
        AtomicBoolean cf = this.cancelledFlag;
        if (cf != null) {
            cf.set(true);
        }
    }

    @Override
    public boolean checkIfTripped() {
        return this.checkIfTripped(this.powerUpTime, this.fd);
    }

    @Override
    public boolean checkIfTripped(long millis, long fd) {
        if (this.clock.getTicks() - this.timeout > millis) {
            return true;
        }
        if (this.cancelledFlag != null && this.cancelledFlag.get()) {
            return true;
        }
        return this.testConnection(fd);
    }

    @Override
    public void clear() {
        this.secret = -1;
        this.powerUpTime = Long.MAX_VALUE;
        this.testCount = 0;
        this.fd = -1L;
        this.timeout = this.defaultMaxTime;
    }

    @Override
    public void close() {
        this.buffer = Unsafe.free(this.buffer, this.bufferSize, this.memoryTag);
        this.fd = -1L;
    }

    @Override
    public AtomicBoolean getCancelledFlag() {
        return this.cancelledFlag;
    }

    @Override
    public SqlExecutionCircuitBreakerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    public int getSecret() {
        return this.secret;
    }

    @Override
    public int getState() {
        return this.getState(this.powerUpTime, this.fd);
    }

    @Override
    public int getState(long millis, long fd) {
        if (this.clock.getTicks() - this.timeout > millis) {
            return 1;
        }
        if (this.cancelledFlag != null && this.cancelledFlag.get()) {
            return 3;
        }
        if (this.testConnection(fd)) {
            return 2;
        }
        return 0;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public boolean isThreadSafe() {
        return false;
    }

    @Override
    public boolean isTimerSet() {
        return this.powerUpTime < Long.MAX_VALUE;
    }

    public NetworkSqlExecutionCircuitBreaker of(long fd) {
        assert (this.buffer != 0L);
        this.testCount = 0;
        this.fd = fd;
        return this;
    }

    public void resetMaxTimeToDefault() {
        this.timeout = this.defaultMaxTime;
    }

    @Override
    public void resetTimer() {
        this.powerUpTime = this.clock.getTicks();
    }

    @Override
    public void setCancelledFlag(AtomicBoolean cancelledFlag) {
        this.cancelledFlag = cancelledFlag;
    }

    @Override
    public void setFd(long fd) {
        this.fd = fd;
    }

    public void setSecret(int secret) {
        this.secret = secret;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void statefulThrowExceptionIfTimeout() {
        if (this.testCount < this.throttle) {
            ++this.testCount;
        } else {
            this.testCount = 0;
            this.testTimeout();
        }
    }

    @Override
    public void statefulThrowExceptionIfTripped() {
        if (this.testCount < this.throttle) {
            ++this.testCount;
        } else {
            this.statefulThrowExceptionIfTrippedNoThrottle();
        }
    }

    @Override
    public void statefulThrowExceptionIfTrippedNoThrottle() {
        this.testCount = 0;
        this.testTimeout();
        this.testCancelled();
        if (this.testConnection(this.fd)) {
            throw CairoException.nonCritical().put("remote disconnected, query aborted [fd=").put(this.fd).put(']').setInterruption(true);
        }
    }

    @Override
    public void unsetTimer() {
        this.powerUpTime = Long.MAX_VALUE;
    }

    private boolean isCancelled() {
        return this.powerUpTime == Long.MIN_VALUE;
    }

    private void testCancelled() {
        if (this.cancelledFlag != null && this.cancelledFlag.get()) {
            throw CairoException.queryCancelled(this.fd);
        }
    }

    private void testTimeout() {
        long runtime = this.clock.getTicks() - this.powerUpTime;
        if (runtime > this.timeout) {
            if (this.isCancelled()) {
                throw CairoException.queryCancelled(this.fd);
            }
            throw CairoException.queryTimedOut(this.fd, runtime, this.timeout);
        }
    }

    protected boolean testConnection(long fd) {
        if (fd == -1L || !this.configuration.checkConnection()) {
            return false;
        }
        return this.nf.testConnection(fd, this.buffer, this.bufferSize);
    }
}

