/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.pool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.pool.AbstractMultiTenantPool;
import io.questdb.cairo.pool.PoolTenant;
import io.questdb.cairo.pool.ResourcePoolSupervisor;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.Path;
import java.io.Closeable;

class TableReaderMetadataTenantImpl
extends TableReaderMetadata
implements PoolTenant<TableReaderMetadataTenantImpl>,
Closeable {
    private static final Log LOG = LogFactory.getLog(TableReaderMetadataTenantImpl.class);
    private final MillisecondClock clock = this.configuration.getMillisecondClock();
    private final int index;
    private AbstractMultiTenantPool.Entry<TableReaderMetadataTenantImpl> entry;
    private boolean initialized;
    private AbstractMultiTenantPool<TableReaderMetadataTenantImpl> pool;
    private long rowCount;
    private TxReader txFile;
    private long txn = 0L;

    TableReaderMetadataTenantImpl(AbstractMultiTenantPool<TableReaderMetadataTenantImpl> pool, AbstractMultiTenantPool.Entry<TableReaderMetadataTenantImpl> entry, int index, TableToken tableToken, boolean lazy) {
        super(pool.getConfiguration(), tableToken);
        if (!lazy) {
            this.initialize(this.configuration, tableToken);
        }
        this.pool = pool;
        this.entry = entry;
        this.index = index;
    }

    @Override
    public void close() {
        if (this.pool != null && this.getEntry() != null && this.pool.returnToPool(this)) {
            return;
        }
        this.txFile = Misc.free(this.txFile);
        super.close();
    }

    @Override
    public AbstractMultiTenantPool.Entry<TableReaderMetadataTenantImpl> getEntry() {
        return this.entry;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public long getMaxTimestamp() {
        return this.txFile.getMaxTimestamp();
    }

    public long getMinTimestamp() {
        return this.txFile.getMinTimestamp();
    }

    public long getTransientRowCount() {
        return this.txFile.getTransientRowCount();
    }

    public long getTxn() {
        return this.txn;
    }

    public long getVersion() {
        return this.txFile.getMetadataVersion();
    }

    @Override
    public void goodbye() {
        this.entry = null;
        this.pool = null;
    }

    @Override
    public void refresh(ResourcePoolSupervisor<TableReaderMetadataTenantImpl> supervisor) {
        this.reload();
    }

    public void reload() {
        if (!this.initialized) {
            this.initialize(this.configuration, this.getTableToken());
        } else {
            if (this.acquireTxn()) {
                return;
            }
            this.reloadSlow();
        }
    }

    public long size() {
        return this.rowCount;
    }

    private boolean acquireTxn() {
        if (this.txn == this.txFile.getTxn()) {
            Unsafe.getUnsafe().loadFence();
            return this.txFile.getVersion() == this.txFile.unsafeReadVersion();
        }
        return false;
    }

    private void initialize(CairoConfiguration configuration, TableToken tableToken) {
        try (Path path = new Path();){
            path.of(configuration.getDbRoot()).concat(tableToken);
            this.txFile = new TxReader(configuration.getFilesFacade()).ofRO(path.concat("_txn").$(), this.getPartitionBy());
            this.load();
            this.initialized = true;
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    private void readTxnSlow(long deadline) {
        long txn;
        int count = 0;
        while (true) {
            if (this.txFile.unsafeLoadAll()) {
                this.txn = txn = this.txFile.getTxn();
                if (this.acquireTxn()) break;
            }
            ++count;
            if (this.clock.getTicks() > deadline) {
                throw CairoException.critical(0).put("Transaction read timeout [src=metadata, timeout=").put(this.configuration.getSpinLockTimeout()).put("ms]");
            }
            Os.pause();
        }
        this.rowCount = this.txFile.getFixedRowCount() + this.txFile.getTransientRowCount();
        LOG.debug().$("new transaction [txn=").$(txn).$(", transientRowCount=").$(this.txFile.getTransientRowCount()).$(", fixedRowCount=").$(this.txFile.getFixedRowCount()).$(", maxTimestamp=").$ts(this.txFile.getMaxTimestamp()).$(", attempts=").$(count).$(", thread=").$(Thread.currentThread().getName()).$(']').$();
    }

    private boolean reloadMetadata(long txnMetadataVersion, long deadline) {
        if (txnMetadataVersion == this.getMetadataVersion()) {
            return true;
        }
        while (true) {
            try {
                if (!this.prepareTransition(txnMetadataVersion)) {
                    if (this.clock.getTicks() < deadline) {
                        return false;
                    }
                    throw CairoException.critical(0).put("Metadata read timeout [src=metadata, timeout=").put(this.configuration.getSpinLockTimeout()).put("ms]");
                }
            }
            catch (CairoException ex) {
                TableUtils.handleMetadataLoadException(this.getTableToken().getTableName(), deadline, ex, this.configuration.getMillisecondClock(), this.configuration.getSpinLockTimeout());
                continue;
            }
            break;
        }
        this.applyTransition();
        return true;
    }

    private void reloadSlow() {
        long deadline = this.clock.getTicks() + this.configuration.getSpinLockTimeout();
        do {
            this.readTxnSlow(deadline);
        } while (!this.reloadMetadata(this.txFile.getMetadataVersion(), deadline));
    }
}

