/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.map.UnorderedVarcharMap;
import io.questdb.cairo.map.UnorderedVarcharMapValue;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.std.Hash;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UnorderedVarcharMapRecord
implements MapRecord {
    private final long[] columnOffsets;
    private final Long256Impl[] keyLong256A;
    private final Long256Impl[] keyLong256B;
    private final DirectUtf8String usA;
    private final DirectUtf8String usB;
    private final UnorderedVarcharMapValue value;
    private final long[] valueOffsets;
    private final long valueSize;
    private long limit;
    private long startAddress;
    private IntList symbolTableIndex;
    private RecordCursor symbolTableResolver;

    UnorderedVarcharMapRecord(long valueSize, long[] valueOffsets, UnorderedVarcharMapValue value, @Nullable ColumnTypes valueTypes) {
        this.valueSize = valueSize;
        this.valueOffsets = valueOffsets;
        this.value = value;
        this.value.linkRecord(this);
        int nColumns = valueTypes != null ? valueTypes.getColumnCount() + 1 : 1;
        this.columnOffsets = new long[nColumns];
        Long256Impl[] long256A = null;
        Long256Impl[] long256B = null;
        long offset = 16L;
        if (valueTypes != null) {
            int n = valueTypes.getColumnCount();
            for (int i = 0; i < n; ++i) {
                int size;
                int columnType = valueTypes.getColumnType(i);
                if (ColumnType.tagOf(columnType) == 13) {
                    if (long256A == null) {
                        long256A = new Long256Impl[nColumns];
                        long256B = new Long256Impl[nColumns];
                    }
                    long256A[i] = new Long256Impl();
                    long256B[i] = new Long256Impl();
                }
                if ((size = ColumnType.sizeOf(columnType)) <= 0) {
                    throw CairoException.nonCritical().put("value type is not supported: ").put(ColumnType.nameOf(columnType));
                }
                this.columnOffsets[i] = offset;
                offset += (long)size;
            }
        }
        this.keyLong256A = long256A;
        this.keyLong256B = long256B;
        this.usA = new DirectUtf8String();
        this.usB = new DirectUtf8String();
    }

    private UnorderedVarcharMapRecord(long valueSize, long[] valueOffsets, long[] columnOffsets, Long256Impl[] keyLong256A, Long256Impl[] keyLong256B) {
        this.valueSize = valueSize;
        this.valueOffsets = valueOffsets;
        this.columnOffsets = columnOffsets;
        this.value = new UnorderedVarcharMapValue(valueSize, valueOffsets);
        this.keyLong256A = keyLong256A;
        this.keyLong256B = keyLong256B;
        this.usA = new DirectUtf8String();
        this.usB = new DirectUtf8String();
    }

    public UnorderedVarcharMapRecord clone() {
        Long256Impl[] long256B;
        Long256Impl[] long256A;
        if (this.keyLong256A != null) {
            int n = this.keyLong256A.length;
            long256A = new Long256Impl[n];
            long256B = new Long256Impl[n];
            for (int i = 0; i < n; ++i) {
                if (this.keyLong256A[i] == null) continue;
                long256A[i] = new Long256Impl();
                long256B[i] = new Long256Impl();
            }
        } else {
            long256A = null;
            long256B = null;
        }
        return new UnorderedVarcharMapRecord(this.valueSize, this.valueOffsets, this.columnOffsets, long256A, long256B);
    }

    @Override
    public void copyToKey(MapKey destKey) {
        UnorderedVarcharMap.Key destBaseKey = (UnorderedVarcharMap.Key)destKey;
        destBaseKey.copyFromStartAddress(this.startAddress);
    }

    @Override
    public void copyValue(MapValue destValue) {
        UnorderedVarcharMapValue destVarcharValue = (UnorderedVarcharMapValue)destValue;
        destVarcharValue.copyRawValue(this.startAddress + 16L);
    }

    @Override
    public boolean getBool(int columnIndex) {
        return Unsafe.getBool(this.addressOfColumn(columnIndex));
    }

    @Override
    public byte getByte(int columnIndex) {
        return Unsafe.getUnsafe().getByte(this.addressOfColumn(columnIndex));
    }

    @Override
    public char getChar(int columnIndex) {
        return Unsafe.getUnsafe().getChar(this.addressOfColumn(columnIndex));
    }

    @Override
    public double getDouble(int columnIndex) {
        return Unsafe.getUnsafe().getDouble(this.addressOfColumn(columnIndex));
    }

    @Override
    public float getFloat(int columnIndex) {
        return Unsafe.getUnsafe().getFloat(this.addressOfColumn(columnIndex));
    }

    @Override
    public byte getGeoByte(int columnIndex) {
        return this.getByte(columnIndex);
    }

    @Override
    public int getGeoInt(int columnIndex) {
        return this.getInt(columnIndex);
    }

    @Override
    public long getGeoLong(int columnIndex) {
        return this.getLong(columnIndex);
    }

    @Override
    public short getGeoShort(int columnIndex) {
        return this.getShort(columnIndex);
    }

    @Override
    public int getIPv4(int columnIndex) {
        return Unsafe.getUnsafe().getInt(this.addressOfColumn(columnIndex));
    }

    @Override
    public int getInt(int columnIndex) {
        return Unsafe.getUnsafe().getInt(this.addressOfColumn(columnIndex));
    }

    @Override
    public long getLong(int columnIndex) {
        return Unsafe.getUnsafe().getLong(this.addressOfColumn(columnIndex));
    }

    @Override
    public long getLong128Hi(int columnIndex) {
        return Unsafe.getUnsafe().getLong(this.addressOfColumn(columnIndex) + 8L);
    }

    @Override
    public long getLong128Lo(int columnIndex) {
        return Unsafe.getUnsafe().getLong(this.addressOfColumn(columnIndex));
    }

    @Override
    public void getLong256(int columnIndex, CharSink<?> sink) {
        Numbers.appendLong256FromUnsafe(this.addressOfColumn(columnIndex), sink);
    }

    @Override
    public Long256 getLong256A(int columnIndex) {
        return this.getLong256Generic(this.keyLong256A, columnIndex);
    }

    @Override
    public Long256 getLong256B(int columnIndex) {
        return this.getLong256Generic(this.keyLong256B, columnIndex);
    }

    @Override
    public long getRowId() {
        return this.startAddress;
    }

    @Override
    public short getShort(int columnIndex) {
        return Unsafe.getUnsafe().getShort(this.addressOfColumn(columnIndex));
    }

    @Override
    public CharSequence getSymA(int columnIndex) {
        return this.symbolTableResolver.getSymbolTable(this.symbolTableIndex.getQuick(columnIndex)).valueOf(this.getInt(columnIndex));
    }

    @Override
    public CharSequence getSymB(int columnIndex) {
        return this.symbolTableResolver.getSymbolTable(this.symbolTableIndex.getQuick(columnIndex)).valueBOf(this.getInt(columnIndex));
    }

    @Override
    public MapValue getValue() {
        return this.value.of(this.startAddress, this.limit, false);
    }

    @Override
    @Nullable
    public Utf8Sequence getVarcharA(int col) {
        return this.getVarchar0(col, this.usA);
    }

    @Override
    @Nullable
    public Utf8Sequence getVarcharB(int col) {
        return this.getVarchar0(col, this.usB);
    }

    @Override
    public int getVarcharSize(int col) {
        long address = this.addressOfColumn(col);
        int sizeWithFlags = Unsafe.getUnsafe().getInt(address + 4L);
        boolean isNull = UnorderedVarcharMap.isSizeNull(sizeWithFlags);
        if (isNull) {
            return -1;
        }
        return sizeWithFlags & 0x3FFFFFFF;
    }

    @Override
    public long keyHashCode() {
        int lenAndFlags = Unsafe.getUnsafe().getInt(this.startAddress + 4L);
        long ptr = Unsafe.getUnsafe().getLong(this.startAddress + 8L) & Long.MAX_VALUE;
        int size = lenAndFlags & 0x3FFFFFFF;
        if (size > 0) {
            return Hash.hashMem64(ptr, size);
        }
        return 0L;
    }

    public void of(long address) {
        this.startAddress = address;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    @Override
    public void setSymbolTableResolver(RecordCursor resolver, IntList symbolTableIndex) {
        this.symbolTableResolver = resolver;
        this.symbolTableIndex = symbolTableIndex;
    }

    private long addressOfColumn(int index) {
        return this.startAddress + this.columnOffsets[index];
    }

    @NotNull
    private Long256 getLong256Generic(Long256Impl[] keyLong256, int columnIndex) {
        long address = this.addressOfColumn(columnIndex);
        Long256Impl long256 = keyLong256[columnIndex];
        long256.fromAddress(address);
        return long256;
    }

    private DirectUtf8String getVarchar0(int col, DirectUtf8String us) {
        long address = this.addressOfColumn(col);
        long packedHashSizeFlags = Unsafe.getUnsafe().getLong(address);
        byte flags = UnorderedVarcharMap.unpackFlags(packedHashSizeFlags);
        if (UnorderedVarcharMap.isNull(flags)) {
            return null;
        }
        boolean isAscii = UnorderedVarcharMap.isAscii(flags);
        long size = UnorderedVarcharMap.unpackSize(packedHashSizeFlags);
        long ptrWithUnstableFlag = Unsafe.getUnsafe().getLong(address + 8L);
        long ptr = ptrWithUnstableFlag & Long.MAX_VALUE;
        return us.of(ptr, ptr + size, isAscii);
    }
}

