/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.DefaultFactoryProvider;
import io.questdb.DefaultMemoryConfiguration;
import io.questdb.DefaultPublicPassthroughConfiguration;
import io.questdb.FactoryProvider;
import io.questdb.MemoryConfiguration;
import io.questdb.Metrics;
import io.questdb.PublicPassthroughConfiguration;
import io.questdb.ServerConfiguration;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.DefaultCairoConfiguration;
import io.questdb.cutlass.http.DefaultHttpServerConfiguration;
import io.questdb.cutlass.http.HttpFullFatServerConfiguration;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.line.tcp.DefaultLineTcpReceiverConfiguration;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.cutlass.line.udp.DefaultLineUdpReceiverConfiguration;
import io.questdb.cutlass.line.udp.LineUdpReceiverConfiguration;
import io.questdb.cutlass.pgwire.DefaultPGConfiguration;
import io.questdb.cutlass.pgwire.PGConfiguration;
import io.questdb.metrics.DefaultMetricsConfiguration;
import io.questdb.metrics.MetricsConfiguration;
import io.questdb.mp.WorkerPoolConfiguration;

public class DefaultServerConfiguration
implements ServerConfiguration {
    private final DefaultCairoConfiguration cairoConfiguration;
    private final DefaultHttpServerConfiguration httpServerConfiguration;
    private final DefaultWorkerPoolConfiguration networkWorkerPoolConfiguration;
    private final DefaultLineTcpReceiverConfiguration lineTcpReceiverConfiguration;
    private final DefaultLineUdpReceiverConfiguration lineUdpReceiverConfiguration = new DefaultLineUdpReceiverConfiguration();
    private final WorkerPoolConfiguration matViewRefreshPoolConfiguration;
    private final DefaultMemoryConfiguration memoryConfiguration = new DefaultMemoryConfiguration();
    private final DefaultMetricsConfiguration metricsConfiguration = new DefaultMetricsConfiguration();
    private final DefaultPGConfiguration pgWireConfiguration = new DefaultPGConfiguration();
    private final PublicPassthroughConfiguration publicPassthroughConfiguration = new DefaultPublicPassthroughConfiguration();
    private final DefaultWorkerPoolConfiguration queryWorkerPoolConfiguration;
    private final WorkerPoolConfiguration walApplyPoolConfiguration;
    private final DefaultWorkerPoolConfiguration writeWorkerPoolConfiguration;

    public DefaultServerConfiguration(CharSequence dbRoot, CharSequence installRoot) {
        this.cairoConfiguration = new DefaultCairoConfiguration(dbRoot, installRoot);
        this.lineTcpReceiverConfiguration = new DefaultLineTcpReceiverConfiguration(this.cairoConfiguration);
        this.httpServerConfiguration = new DefaultHttpServerConfiguration(this.cairoConfiguration);
        this.networkWorkerPoolConfiguration = new DefaultWorkerPoolConfiguration("shared_network");
        this.queryWorkerPoolConfiguration = new DefaultWorkerPoolConfiguration("shared_query");
        this.writeWorkerPoolConfiguration = new DefaultWorkerPoolConfiguration("shared_write");
        this.matViewRefreshPoolConfiguration = new DefaultWorkerPoolConfiguration("mat_view_refresh");
        this.walApplyPoolConfiguration = new DefaultWorkerPoolConfiguration("wal_apply");
    }

    public DefaultServerConfiguration(CharSequence dbRoot) {
        this(dbRoot, null);
    }

    @Override
    public CairoConfiguration getCairoConfiguration() {
        return this.cairoConfiguration;
    }

    @Override
    public FactoryProvider getFactoryProvider() {
        return DefaultFactoryProvider.INSTANCE;
    }

    @Override
    public HttpServerConfiguration getHttpMinServerConfiguration() {
        return null;
    }

    @Override
    public HttpFullFatServerConfiguration getHttpServerConfiguration() {
        return this.httpServerConfiguration;
    }

    @Override
    public WorkerPoolConfiguration getNetworkWorkerPoolConfiguration() {
        return this.networkWorkerPoolConfiguration;
    }

    @Override
    public LineTcpReceiverConfiguration getLineTcpReceiverConfiguration() {
        return this.lineTcpReceiverConfiguration;
    }

    @Override
    public LineUdpReceiverConfiguration getLineUdpReceiverConfiguration() {
        return this.lineUdpReceiverConfiguration;
    }

    @Override
    public WorkerPoolConfiguration getMatViewRefreshPoolConfiguration() {
        return this.matViewRefreshPoolConfiguration;
    }

    @Override
    public MemoryConfiguration getMemoryConfiguration() {
        return this.memoryConfiguration;
    }

    @Override
    public Metrics getMetrics() {
        return Metrics.ENABLED;
    }

    @Override
    public MetricsConfiguration getMetricsConfiguration() {
        return this.metricsConfiguration;
    }

    @Override
    public PGConfiguration getPGWireConfiguration() {
        return this.pgWireConfiguration;
    }

    @Override
    public PublicPassthroughConfiguration getPublicPassthroughConfiguration() {
        return this.publicPassthroughConfiguration;
    }

    @Override
    public WorkerPoolConfiguration getQueryWorkerPoolConfiguration() {
        return this.queryWorkerPoolConfiguration;
    }

    @Override
    public WorkerPoolConfiguration getWalApplyPoolConfiguration() {
        return this.walApplyPoolConfiguration;
    }

    @Override
    public WorkerPoolConfiguration getWriteWorkerPoolConfiguration() {
        return this.writeWorkerPoolConfiguration;
    }

    private static class DefaultWorkerPoolConfiguration
    implements WorkerPoolConfiguration {
        private final String name;

        private DefaultWorkerPoolConfiguration(String name) {
            this.name = name;
        }

        @Override
        public String getPoolName() {
            return this.name;
        }

        @Override
        public int getWorkerCount() {
            return 2;
        }
    }
}

