/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.log.controller;

import io.swagger.v3.oas.annotations.Operation;
import org.apache.hertzbeat.common.util.SnowFlakeIdGenerator;
import org.apache.hertzbeat.log.notice.LogSseFilterCriteria;
import org.apache.hertzbeat.log.notice.LogSseManager;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@RequestMapping(path={"/api/logs/sse"}, produces={"text/event-stream"})
public class LogSseController {
    private final LogSseManager emitterManager;

    public LogSseController(LogSseManager emitterManager) {
        this.emitterManager = emitterManager;
    }

    @GetMapping(path={"/subscribe"})
    @Operation(summary="Subscribe to log events with optional filtering", description="Subscribe to log events with optional filtering")
    public SseEmitter subscribe(@ModelAttribute LogSseFilterCriteria filterCriteria) {
        Long clientId = SnowFlakeIdGenerator.generateId();
        return this.emitterManager.createEmitter(clientId, filterCriteria);
    }
}

