/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.lang.reflect.Method;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public interface ParametersSource {
    public static ParametersSource of(final Method method) {
        Assert.notNull((Object)method, (String)"Method must not be null");
        return new ParametersSource(){

            @Override
            public Class<?> getContainingClass() {
                return method.getDeclaringClass();
            }

            @Override
            public Method getMethod() {
                return method;
            }

            @Override
            public TypeInformation<?> getDomainTypeInformation() {
                return TypeInformation.OBJECT;
            }
        };
    }

    public static ParametersSource of(final RepositoryMetadata metadata, final Method method) {
        Assert.notNull((Object)metadata, (String)"RepositoryMetadata must not be null");
        Assert.notNull((Object)method, (String)"Method must not be null");
        return new ParametersSource(){

            @Override
            public Class<?> getContainingClass() {
                return metadata.getRepositoryInterface();
            }

            @Override
            public Method getMethod() {
                return method;
            }

            @Override
            public TypeInformation<?> getDomainTypeInformation() {
                return metadata.getDomainTypeInformation();
            }
        };
    }

    public Class<?> getContainingClass();

    public Method getMethod();

    public TypeInformation<?> getDomainTypeInformation();
}

