/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.timer;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hertzbeat.collector.constants.ScheduleTypeEnum;
import org.apache.hertzbeat.collector.dispatch.entrance.internal.CollectResponseEventListener;
import org.apache.hertzbeat.collector.timer.TimerDispatch;
import org.apache.hertzbeat.collector.timer.WheelTimerTask;
import org.apache.hertzbeat.common.entity.job.Job;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.timer.HashedWheelTimer;
import org.apache.hertzbeat.common.timer.Timeout;
import org.apache.hertzbeat.common.timer.Timer;
import org.apache.hertzbeat.common.timer.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.support.CronExpression;
import org.springframework.stereotype.Component;

@Component
public class TimerDispatcher
implements TimerDispatch,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(TimerDispatcher.class);
    private final Timer wheelTimer = new HashedWheelTimer(r -> {
        Thread ret = new Thread(r, "wheelTimer");
        ret.setDaemon(true);
        return ret;
    }, 1L, TimeUnit.SECONDS, 512);
    private final Map<Long, Timeout> currentCyclicTaskMap = new ConcurrentHashMap<Long, Timeout>(8);
    private final Map<Long, Timeout> currentTempTaskMap = new ConcurrentHashMap<Long, Timeout>(8);
    private final Map<Long, CollectResponseEventListener> eventListeners = new ConcurrentHashMap<Long, CollectResponseEventListener>(8);
    private final AtomicBoolean started = new AtomicBoolean(true);

    @Override
    public void addJob(Job addJob, CollectResponseEventListener eventListener) {
        if (!this.started.get()) {
            log.warn("Collector is offline, can not dispatch collect jobs.");
            return;
        }
        WheelTimerTask timerJob = new WheelTimerTask(addJob);
        if (addJob.isCyclic()) {
            Long nextExecutionTime = this.getNextExecutionInterval(addJob);
            Timeout timeout = this.wheelTimer.newTimeout((TimerTask)timerJob, nextExecutionTime.longValue(), TimeUnit.SECONDS);
            this.currentCyclicTaskMap.put(addJob.getId(), timeout);
        } else {
            for (Metrics metric : addJob.getMetrics()) {
                metric.setInterval(0L);
            }
            addJob.setIntervals(new ConcurrentLinkedDeque<Long>(List.of(Long.valueOf(0L))));
            Timeout timeout = this.wheelTimer.newTimeout((TimerTask)timerJob, addJob.getInterval(), TimeUnit.SECONDS);
            this.currentTempTaskMap.put(addJob.getId(), timeout);
            this.eventListeners.put(addJob.getId(), eventListener);
        }
    }

    @Override
    public void cyclicJob(WheelTimerTask timerTask, long interval, TimeUnit timeUnit) {
        if (!this.started.get()) {
            log.warn("Collector is offline, can not dispatch collect jobs.");
            return;
        }
        Long jobId = timerTask.getJob().getId();
        if (this.currentCyclicTaskMap.containsKey(jobId)) {
            Timeout timeout = this.wheelTimer.newTimeout((TimerTask)timerTask, interval, TimeUnit.SECONDS);
            this.currentCyclicTaskMap.put(timerTask.getJob().getId(), timeout);
        }
    }

    @Override
    public void cyclicJob(WheelTimerTask timerTask) {
        Job job = timerTask.getJob();
        Long nextExecutionTime = this.getNextExecutionInterval(job);
        this.cyclicJob(timerTask, nextExecutionTime, TimeUnit.SECONDS);
    }

    @Override
    public void deleteJob(long jobId, boolean isCyclic) {
        if (isCyclic) {
            Timeout timeout = this.currentCyclicTaskMap.remove(jobId);
            if (timeout != null) {
                timeout.cancel();
            }
        } else {
            Timeout timeout = this.currentTempTaskMap.remove(jobId);
            if (timeout != null) {
                timeout.cancel();
            }
        }
    }

    @Override
    public void goOnline() {
        this.currentCyclicTaskMap.forEach((key, value) -> value.cancel());
        this.currentCyclicTaskMap.clear();
        this.currentTempTaskMap.forEach((key, value) -> value.cancel());
        this.currentTempTaskMap.clear();
        this.started.set(true);
    }

    @Override
    public void goOffline() {
        this.started.set(false);
        this.currentCyclicTaskMap.forEach((key, value) -> value.cancel());
        this.currentCyclicTaskMap.clear();
        this.currentTempTaskMap.forEach((key, value) -> value.cancel());
        this.currentTempTaskMap.clear();
    }

    @Override
    public void responseSyncJobData(long jobId, List<CollectRep.MetricsData> metricsDataTemps) {
        this.currentTempTaskMap.remove(jobId);
        CollectResponseEventListener eventListener = this.eventListeners.remove(jobId);
        if (eventListener != null) {
            eventListener.response(metricsDataTemps);
        }
    }

    public void destroy() throws Exception {
        this.wheelTimer.stop();
    }

    public Long getNextExecutionInterval(Job job) {
        if (ScheduleTypeEnum.CRON.getType().equals(job.getScheduleType()) && job.getCronExpression() != null && !job.getCronExpression().isEmpty()) {
            try {
                CronExpression cronExpression = CronExpression.parse((String)job.getCronExpression());
                ZonedDateTime nextExecutionTime = (ZonedDateTime)cronExpression.next((Temporal)ZonedDateTime.now());
                long delay = Duration.between(ZonedDateTime.now(), nextExecutionTime).toMillis();
                return Math.max(0L, delay / 1000L);
            }
            catch (Exception e) {
                log.error("Invalid cron expression: {}", (Object)job.getCronExpression(), (Object)e);
                return job.getInterval();
            }
        }
        if (job.getDispatchTime() > 0L) {
            long spendTime = System.currentTimeMillis() - job.getDispatchTime();
            long intervalMs = job.getInterval() * 1000L - spendTime;
            return Math.max(0L, intervalMs / 1000L);
        }
        return job.getInterval();
    }
}

