/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lance.common.ops.gravitino;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.lancedb.lance.namespace.LanceNamespaceException;
import com.lancedb.lance.namespace.ObjectIdentifier;
import com.lancedb.lance.namespace.model.CreateNamespaceRequest;
import com.lancedb.lance.namespace.model.CreateNamespaceResponse;
import com.lancedb.lance.namespace.model.DescribeNamespaceResponse;
import com.lancedb.lance.namespace.model.DropNamespaceRequest;
import com.lancedb.lance.namespace.model.DropNamespaceResponse;
import com.lancedb.lance.namespace.model.ListNamespacesResponse;
import com.lancedb.lance.namespace.model.ListTablesResponse;
import com.lancedb.lance.namespace.util.CommonUtil;
import com.lancedb.lance.namespace.util.PageUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.CatalogChange;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.Schema;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.CatalogAlreadyExistsException;
import org.apache.gravitino.exceptions.CatalogInUseException;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NonEmptyCatalogException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.lance.common.ops.LanceNamespaceOperations;
import org.apache.gravitino.lance.common.ops.gravitino.GravitinoLanceNamespaceWrapper;

public class GravitinoLanceNameSpaceOperations
implements LanceNamespaceOperations {
    private final GravitinoLanceNamespaceWrapper namespaceWrapper;
    private final GravitinoClient client;

    public GravitinoLanceNameSpaceOperations(GravitinoLanceNamespaceWrapper namespaceWrapper) {
        this.namespaceWrapper = namespaceWrapper;
        this.client = namespaceWrapper.getClient();
    }

    @Override
    public ListNamespacesResponse listNamespaces(String namespaceId, String delimiter, String pageToken, Integer limit) {
        ObjectIdentifier nsId = ObjectIdentifier.of((String)namespaceId, (String)delimiter);
        Preconditions.checkArgument((nsId.levels() <= 2 ? 1 : 0) != 0, (String)"Expected at most 2-level namespace but got: %s", (Object)namespaceId);
        List<Object> namespaces = switch (nsId.levels()) {
            case 0 -> Arrays.stream(this.client.listCatalogsInfo()).filter(this.namespaceWrapper::isLakehouseCatalog).map(Catalog::name).collect(Collectors.toList());
            case 1 -> {
                Catalog catalog = this.namespaceWrapper.loadAndValidateLakehouseCatalog(nsId.levelAtListPos(0));
                yield Lists.newArrayList((Object[])catalog.asSchemas().listSchemas());
            }
            case 2 -> Lists.newArrayList();
            default -> throw new IllegalArgumentException("Expected at most 2-level namespace but got: " + namespaceId);
        };
        Collections.sort(namespaces);
        PageUtil.Page page = PageUtil.splitPage((List)namespaces, (String)pageToken, (int)PageUtil.normalizePageSize((Integer)limit));
        ListNamespacesResponse response = new ListNamespacesResponse();
        response.setNamespaces((Set)Sets.newHashSet((Iterable)page.items()));
        response.setPageToken(page.nextPageToken());
        return response;
    }

    @Override
    public DescribeNamespaceResponse describeNamespace(String namespaceId, String delimiter) {
        ObjectIdentifier nsId = ObjectIdentifier.of((String)namespaceId, (String)delimiter);
        Preconditions.checkArgument((nsId.levels() <= 2 && nsId.levels() > 0 ? 1 : 0) != 0, (String)"Expected at most 2-level and at least 1-level namespace but got: %s", (Object)namespaceId);
        Catalog catalog = this.namespaceWrapper.loadAndValidateLakehouseCatalog(nsId.levelAtListPos(0));
        HashMap properties = Maps.newHashMap();
        switch (nsId.levels()) {
            case 1: {
                Optional.ofNullable(catalog.properties()).ifPresent(properties::putAll);
                break;
            }
            case 2: {
                String schemaName = nsId.levelAtListPos(1);
                Schema schema = catalog.asSchemas().loadSchema(schemaName);
                Optional.ofNullable(schema.properties()).ifPresent(properties::putAll);
                break;
            }
            default: {
                throw new IllegalArgumentException("Expected at most 2-level and at least 1-level namespace but got: " + namespaceId);
            }
        }
        DescribeNamespaceResponse response = new DescribeNamespaceResponse();
        response.setProperties((Map)properties);
        return response;
    }

    @Override
    public CreateNamespaceResponse createNamespace(String namespaceId, String delimiter, CreateNamespaceRequest.ModeEnum mode, Map<String, String> properties) {
        ObjectIdentifier nsId = ObjectIdentifier.of((String)namespaceId, (String)delimiter);
        Preconditions.checkArgument((nsId.levels() <= 2 && nsId.levels() > 0 ? 1 : 0) != 0, (String)"Expected at most 2-level and at least 1-level namespace but got: %s", (Object)namespaceId);
        switch (nsId.levels()) {
            case 1: {
                return this.createOrUpdateCatalog(nsId.levelAtListPos(0), mode, properties);
            }
            case 2: {
                return this.createOrUpdateSchema(nsId.levelAtListPos(0), nsId.levelAtListPos(1), mode, properties);
            }
        }
        throw new IllegalArgumentException("Expected at most 2-level and at least 1-level namespace but got: " + namespaceId);
    }

    @Override
    public DropNamespaceResponse dropNamespace(String namespaceId, String delimiter, DropNamespaceRequest.ModeEnum mode, DropNamespaceRequest.BehaviorEnum behavior) {
        ObjectIdentifier nsId = ObjectIdentifier.of((String)namespaceId, (String)delimiter);
        Preconditions.checkArgument((nsId.levels() <= 2 && nsId.levels() > 0 ? 1 : 0) != 0, (String)"Expected at most 2-level and at least 1-level namespace but got: %s", (Object)namespaceId);
        switch (nsId.levels()) {
            case 1: {
                return this.dropCatalog(nsId.levelAtListPos(0), mode, behavior);
            }
            case 2: {
                return this.dropSchema(nsId.levelAtListPos(0), nsId.levelAtListPos(1), mode, behavior);
            }
        }
        throw new IllegalArgumentException("Expected at most 2-level and at least 1-level namespace but got: " + namespaceId);
    }

    @Override
    public void namespaceExists(String namespaceId, String delimiter) throws LanceNamespaceException {
        ObjectIdentifier nsId = ObjectIdentifier.of((String)namespaceId, (String)delimiter);
        Preconditions.checkArgument((nsId.levels() <= 2 && nsId.levels() > 0 ? 1 : 0) != 0, (String)"Expected at most 2-level and at least 1-level namespace but got: %s", (Object)namespaceId);
        Catalog catalog = this.namespaceWrapper.loadAndValidateLakehouseCatalog(nsId.levelAtListPos(0));
        if (nsId.levels() == 2) {
            String schemaName = nsId.levelAtListPos(1);
            if (!catalog.asSchemas().schemaExists(schemaName)) {
                throw LanceNamespaceException.notFound((String)("Schema not found: " + schemaName), (String)NoSuchSchemaException.class.getSimpleName(), (String)schemaName, (String)CommonUtil.formatCurrentStackTrace());
            }
        }
    }

    private CreateNamespaceResponse createOrUpdateCatalog(String catalogName, CreateNamespaceRequest.ModeEnum mode, Map<String, String> properties) {
        Catalog catalog;
        CreateNamespaceResponse response = new CreateNamespaceResponse();
        try {
            catalog = this.client.loadCatalog(catalogName);
        }
        catch (NoSuchCatalogException e) {
            Catalog createdCatalog = this.client.createCatalog(catalogName, Catalog.Type.RELATIONAL, "lakehouse-generic", "created by Lance REST server", properties);
            response.setProperties(createdCatalog.properties() == null ? Maps.newHashMap() : createdCatalog.properties());
            return response;
        }
        if (!this.namespaceWrapper.isLakehouseCatalog(catalog)) {
            throw LanceNamespaceException.conflict((String)("Catalog already exists but is not a lakehouse catalog: " + catalogName), (String)CatalogAlreadyExistsException.class.getSimpleName(), (String)catalogName, (String)CommonUtil.formatCurrentStackTrace());
        }
        switch (mode) {
            case EXIST_OK: {
                response.setProperties(Optional.ofNullable(catalog.properties()).orElse(Collections.emptyMap()));
                return response;
            }
            case CREATE: {
                throw LanceNamespaceException.conflict((String)("Catalog already exists: " + catalogName), (String)CatalogAlreadyExistsException.class.getSimpleName(), (String)catalogName, (String)CommonUtil.formatCurrentStackTrace());
            }
            case OVERWRITE: {
                CatalogChange[] changes = this.buildChanges(properties, this.removeInUseProperty(catalog.properties()), CatalogChange::setProperty, CatalogChange::removeProperty, CatalogChange[]::new);
                Catalog alteredCatalog = this.client.alterCatalog(catalogName, changes);
                Optional.ofNullable(alteredCatalog.properties()).ifPresent(arg_0 -> ((CreateNamespaceResponse)response).setProperties(arg_0));
                return response;
            }
        }
        throw new IllegalArgumentException("Unknown mode: " + String.valueOf(mode));
    }

    private Map<String, String> removeInUseProperty(Map<String, String> properties) {
        return properties.entrySet().stream().filter(e -> !((String)e.getKey()).equalsIgnoreCase("in-use")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private CreateNamespaceResponse createOrUpdateSchema(String catalogName, String schemaName, CreateNamespaceRequest.ModeEnum mode, Map<String, String> properties) {
        Schema schema;
        CreateNamespaceResponse response = new CreateNamespaceResponse();
        Catalog loadedCatalog = this.namespaceWrapper.loadAndValidateLakehouseCatalog(catalogName);
        try {
            schema = loadedCatalog.asSchemas().loadSchema(schemaName);
        }
        catch (NoSuchSchemaException e) {
            Schema createdSchema = loadedCatalog.asSchemas().createSchema(schemaName, null, properties);
            response.setProperties(createdSchema.properties() == null ? Maps.newHashMap() : createdSchema.properties());
            return response;
        }
        switch (mode) {
            case EXIST_OK: {
                response.setProperties(Optional.ofNullable(schema.properties()).orElse(Collections.emptyMap()));
                return response;
            }
            case CREATE: {
                throw LanceNamespaceException.conflict((String)("Schema already exists: " + schemaName), (String)SchemaAlreadyExistsException.class.getSimpleName(), (String)schemaName, (String)CommonUtil.formatCurrentStackTrace());
            }
            case OVERWRITE: {
                SchemaChange[] changes = this.buildChanges(properties, schema.properties(), SchemaChange::setProperty, SchemaChange::removeProperty, SchemaChange[]::new);
                Schema alteredSchema = loadedCatalog.asSchemas().alterSchema(schemaName, changes);
                Optional.ofNullable(alteredSchema.properties()).ifPresent(arg_0 -> ((CreateNamespaceResponse)response).setProperties(arg_0));
                return response;
            }
        }
        throw new IllegalArgumentException("Unknown mode: " + String.valueOf(mode));
    }

    private DropNamespaceResponse dropCatalog(String catalogName, DropNamespaceRequest.ModeEnum mode, DropNamespaceRequest.BehaviorEnum behavior) {
        try {
            boolean dropped = this.client.dropCatalog(catalogName, behavior == DropNamespaceRequest.BehaviorEnum.CASCADE);
            if (dropped) {
                return new DropNamespaceResponse();
            }
            if (mode == DropNamespaceRequest.ModeEnum.FAIL) {
                throw LanceNamespaceException.notFound((String)("Catalog not found: " + catalogName), (String)NoSuchCatalogException.class.getSimpleName(), (String)catalogName, (String)CommonUtil.formatCurrentStackTrace());
            }
            return new DropNamespaceResponse();
        }
        catch (CatalogInUseException | NonEmptyCatalogException e) {
            throw LanceNamespaceException.badRequest((String)String.format("Catalog %s is not empty or in used", catalogName), (String)NonEmptyCatalogException.class.getSimpleName(), (String)catalogName, (String)CommonUtil.formatCurrentStackTrace());
        }
    }

    private DropNamespaceResponse dropSchema(String catalogName, String schemaName, DropNamespaceRequest.ModeEnum mode, DropNamespaceRequest.BehaviorEnum behavior) {
        try {
            boolean dropped = this.client.loadCatalog(catalogName).asSchemas().dropSchema(schemaName, behavior == DropNamespaceRequest.BehaviorEnum.CASCADE);
            if (dropped) {
                return new DropNamespaceResponse();
            }
            if (mode == DropNamespaceRequest.ModeEnum.FAIL) {
                throw LanceNamespaceException.notFound((String)("Schema not found: " + schemaName), (String)NoSuchSchemaException.class.getSimpleName(), (String)schemaName, (String)CommonUtil.formatCurrentStackTrace());
            }
            return new DropNamespaceResponse();
        }
        catch (NoSuchCatalogException e) {
            throw LanceNamespaceException.notFound((String)("Catalog not found: " + catalogName), (String)NoSuchCatalogException.class.getSimpleName(), (String)catalogName, (String)CommonUtil.formatCurrentStackTrace());
        }
        catch (NonEmptySchemaException e) {
            throw LanceNamespaceException.badRequest((String)String.format("Schema %s is not empty.", schemaName), (String)NonEmptySchemaException.class.getSimpleName(), (String)schemaName, (String)CommonUtil.formatCurrentStackTrace());
        }
    }

    private <T> T[] buildChanges(Map<String, String> newProps, Map<String, String> oldProps, BiFunction<String, String, T> setPropertyFunc, Function<String, T> removePropertyFunc, IntFunction<T[]> arrayCreator) {
        Stream<Object> setPropertiesStream = newProps.entrySet().stream().map(entry -> setPropertyFunc.apply((String)entry.getKey(), (String)entry.getValue()));
        Stream removePropertiesStream = oldProps == null ? Stream.empty() : oldProps.keySet().stream().filter(key -> !newProps.containsKey(key)).map(removePropertyFunc);
        return Stream.concat(setPropertiesStream, removePropertiesStream).toArray(arrayCreator);
    }

    @Override
    public ListTablesResponse listTables(String namespaceId, String delimiter, String pageToken, Integer limit) {
        ObjectIdentifier nsId = ObjectIdentifier.of((String)namespaceId, (String)Pattern.quote(delimiter));
        Preconditions.checkArgument((nsId.levels() == 2 ? 1 : 0) != 0, (String)"Expected 2-level namespace but got: %s", (int)nsId.levels());
        String catalogName = nsId.levelAtListPos(0);
        Catalog catalog = this.namespaceWrapper.loadAndValidateLakehouseCatalog(catalogName);
        String schemaName = nsId.levelAtListPos(1);
        List tables = Arrays.stream(catalog.asTableCatalog().listTables(Namespace.of((String[])new String[]{schemaName}))).map(ident -> Joiner.on((String)delimiter).join((Object)catalogName, (Object)schemaName, new Object[]{ident.name()})).sorted().collect(Collectors.toList());
        PageUtil.Page page = PageUtil.splitPage(tables, (String)pageToken, (int)PageUtil.normalizePageSize((Integer)limit));
        ListNamespacesResponse response = new ListNamespacesResponse();
        response.setNamespaces((Set)Sets.newHashSet((Iterable)page.items()));
        response.setPageToken(page.nextPageToken());
        return new ListTablesResponse().tables(response.getNamespaces()).pageToken(response.getPageToken());
    }
}

