/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.apache.gravitino.dto.responses.BaseResponse;

public class DropResponse
extends BaseResponse {
    @JsonProperty(value="dropped")
    private final Boolean dropped;
    @JsonProperty(value="deleted")
    private final Boolean deleted;

    public DropResponse(Boolean dropped) {
        super(0);
        this.dropped = dropped;
        this.deleted = null;
    }

    public DropResponse(Boolean dropped, Boolean deleted) {
        super(0);
        this.dropped = dropped;
        this.deleted = deleted;
    }

    public DropResponse() {
        this.dropped = null;
        this.deleted = null;
    }

    public Boolean dropped() {
        return this.dropped != null ? this.dropped : this.deleted;
    }

    @VisibleForTesting
    public Boolean deleted() {
        return this.deleted;
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((this.dropped != null || this.deleted != null ? 1 : 0) != 0, (Object)"Either 'dropped' or 'deleted' must be set in DropResponse");
    }

    @Override
    public String toString() {
        return "DropResponse(dropped=" + this.dropped + ", deleted=" + this.deleted + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DropResponse)) {
            return false;
        }
        DropResponse other = (DropResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$dropped = this.dropped;
        Boolean other$dropped = other.dropped;
        if (this$dropped == null ? other$dropped != null : !((Object)this$dropped).equals(other$dropped)) {
            return false;
        }
        Boolean this$deleted = this.deleted;
        Boolean other$deleted = other.deleted;
        return !(this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DropResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $dropped = this.dropped;
        result = result * 59 + ($dropped == null ? 43 : ((Object)$dropped).hashCode());
        Boolean $deleted = this.deleted;
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        return result;
    }
}

