/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.jcasbin.persist.file_adapter;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.jcasbin.persist.Helper;

public class AdapterMock
implements Adapter {
    private String filePath;
    private String errorValue;

    public AdapterMock(String filePath) {
        this.filePath = filePath;
    }

    public void setMockErr(String errorToSet) {
        this.errorValue = errorToSet;
    }

    public Exception getMockErr() {
        if (this.errorValue != null && !this.errorValue.isEmpty()) {
            return new Exception(this.errorValue);
        }
        return null;
    }

    @Override
    public void loadPolicy(Model model) {
        try {
            this.loadPolicyFile(model, Helper::loadPolicyLine);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void savePolicy(Model model) {
    }

    @Override
    public void addPolicy(String sec, String ptype, List<String> rule) {
    }

    @Override
    public void removePolicy(String sec, String ptype, List<String> rule) {
    }

    @Override
    public void removeFilteredPolicy(String sec, String ptype, int fieldIndex, String ... fieldValues) {
    }

    private void loadPolicyFile(Model model, Helper.loadPolicyLineHandler<String, Model> handler) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(this.filePath));){
            String line;
            while ((line = br.readLine()) != null) {
                line = line.trim();
                handler.accept(line, model);
            }
        }
    }
}

