/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web;

import com.codahale.metrics.Clock;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import com.codahale.metrics.jersey2.InstrumentedResourceMethodApplicationListener;
import java.util.concurrent.TimeUnit;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.server.web.JettyServer;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.server.ResourceConfig;

public class HttpServerMetricsSource
extends MetricsSource {
    public HttpServerMetricsSource(String name, ResourceConfig resourceConfig, JettyServer server) {
        super(name);
        resourceConfig.register((Object)new InstrumentedResourceMethodApplicationListener(this.getMetricRegistry(), Clock.defaultClock(), false, () -> new SlidingTimeWindowArrayReservoir((long)this.getTimeSlidingWindowSeconds(), TimeUnit.SECONDS)));
        ThreadPool threadPool = server.getThreadPool();
        this.registerGauge("http-server.idle-thread.num", () -> threadPool.getIdleThreads());
        this.registerGauge("http-server.total-thread.num", () -> threadPool.getThreads());
        if (threadPool instanceof QueuedThreadPool) {
            QueuedThreadPool queuedThreadPool = (QueuedThreadPool)threadPool;
            this.registerGauge("http-server.busy-thread.num", () -> queuedThreadPool.getBusyThreads());
            this.registerGauge("http-server.queued-request.num", () -> queuedThreadPool.getQueueSize());
            this.registerGauge("http-server.min-thread.num", () -> queuedThreadPool.getMinThreads());
            this.registerGauge("http-server.max-thread.num", () -> queuedThreadPool.getMaxThreads());
        }
    }
}

