/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.abs.credential;

import java.util.Map;
import org.apache.gravitino.credential.AzureAccountKeyCredential;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.CredentialContext;
import org.apache.gravitino.credential.CredentialProvider;
import org.apache.gravitino.credential.config.AzureCredentialConfig;

public class AzureAccountKeyProvider
implements CredentialProvider {
    private String accountName;
    private String accountKey;

    public void initialize(Map<String, String> properties) {
        AzureCredentialConfig azureCredentialConfig = new AzureCredentialConfig(properties);
        this.accountName = azureCredentialConfig.storageAccountName();
        this.accountKey = azureCredentialConfig.storageAccountKey();
    }

    public void close() {
    }

    public String credentialType() {
        return "azure-account-key";
    }

    public Credential getCredential(CredentialContext context) {
        return new AzureAccountKeyCredential(this.accountName, this.accountKey);
    }
}

