/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.table.source.snapshot.AbstractStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousLatestStartingScanner
extends AbstractStartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ContinuousLatestStartingScanner.class);

    public ContinuousLatestStartingScanner(SnapshotManager snapshotManager) {
        super(snapshotManager);
        this.startingSnapshotId = snapshotManager.latestSnapshotId();
    }

    @Override
    public StartingScanner.Result scan(SnapshotReader snapshotReader) {
        Long latestSnapshotId = this.snapshotManager.latestSnapshotId();
        if (latestSnapshotId == null) {
            LOG.debug("There is currently no snapshot. Wait for the snapshot generation.");
            return new StartingScanner.NoSnapshot();
        }
        long nextSnapshot = this.startingSnapshotId == null ? 1L : latestSnapshotId + 1L;
        return new StartingScanner.NextSnapshot(nextSnapshot);
    }
}

