/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalWindow;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableWindowGroupReorderRule;
import org.immutables.value.Value;

@Value.Enclosing
public class WindowGroupReorderRule
extends RelRule<WindowGroupReorderRuleConfig> {
    public static final WindowGroupReorderRule INSTANCE = WindowGroupReorderRuleConfig.DEFAULT.toRule();

    private WindowGroupReorderRule(WindowGroupReorderRuleConfig config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalWindow window = (LogicalWindow)call.rel(0);
        return window.groups.size() > 1;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalWindow window = (LogicalWindow)call.rel(0);
        Object input = call.rel(1);
        ArrayList oldGroups = new ArrayList(window.groups);
        ArrayList<Window.Group> sequenceGroups = new ArrayList<Window.Group>(window.groups);
        sequenceGroups.sort((o1, o2) -> {
            int keyComp = o1.keys.compareTo(o2.keys);
            if (keyComp == 0) {
                return this.compareRelCollation(o1.orderKeys, o2.orderKeys);
            }
            return keyComp;
        });
        ArrayList reverseSequenceGroups = new ArrayList(window.groups);
        Collections.reverse(reverseSequenceGroups);
        if (!sequenceGroups.equals(oldGroups) && !reverseSequenceGroups.equals(oldGroups)) {
            int offset = input.getRowType().getFieldCount();
            ArrayList<int[]> aggTypeIndexes = new ArrayList<int[]>();
            for (Object group : oldGroups) {
                int aggCount = ((Window.Group)group).aggCalls.size();
                int[] typeIndexes = new int[aggCount];
                for (int i = 0; i < aggCount; ++i) {
                    typeIndexes[i] = offset + i;
                }
                offset += aggCount;
                aggTypeIndexes.add(typeIndexes);
            }
            offset = input.getRowType().getFieldCount();
            List mapToOldTypeIndexes = IntStream.range(0, offset).boxed().collect(Collectors.toList());
            for (Window.Group newGroup : sequenceGroups) {
                int aggCount = newGroup.aggCalls.size();
                int oldIndex = oldGroups.indexOf(newGroup);
                offset += aggCount;
                for (int aggIndex = 0; aggIndex < aggCount; ++aggIndex) {
                    mapToOldTypeIndexes.add(((int[])aggTypeIndexes.get(oldIndex))[aggIndex]);
                }
            }
            List newFieldList = mapToOldTypeIndexes.stream().map(index -> window.getRowType().getFieldList().get((int)index)).collect(Collectors.toList());
            RelDataType intermediateRowType = window.getCluster().getTypeFactory().createStructType(newFieldList);
            LogicalWindow newLogicalWindow = LogicalWindow.create(window.getCluster().getPlanner().emptyTraitSet(), input, window.constants, intermediateRowType, sequenceGroups);
            List sortedIndices = IntStream.range(0, mapToOldTypeIndexes.size()).boxed().sorted(Comparator.comparingInt(mapToOldTypeIndexes::get)).collect(Collectors.toList());
            List projects = sortedIndices.stream().map(index -> new RexInputRef((int)index, (RelDataType)((Map.Entry)newFieldList.get((int)index)).getValue())).collect(Collectors.toList());
            LogicalProject project = LogicalProject.create((RelNode)newLogicalWindow, Collections.emptyList(), projects, window.getRowType());
            call.transformTo(project);
        }
    }

    private int compareRelCollation(RelCollation o1, RelCollation o2) {
        int comp = o1.compareTo(o2);
        if (comp == 0) {
            List<RelFieldCollation> collations1 = o1.getFieldCollations();
            List<RelFieldCollation> collations2 = o2.getFieldCollations();
            for (int index = 0; index < collations1.size(); ++index) {
                RelFieldCollation collation1 = collations1.get(index);
                RelFieldCollation collation2 = collations2.get(index);
                int direction = collation1.getDirection().shortString.compareTo(collation2.getDirection().shortString);
                if (direction == 0) {
                    int nullDirection = Integer.compare(collation1.nullDirection.nullComparison, collation2.nullDirection.nullComparison);
                    if (nullDirection == 0) continue;
                    return nullDirection;
                }
                return direction;
            }
        }
        return comp;
    }

    @Value.Immutable(singleton=false)
    public static interface WindowGroupReorderRuleConfig
    extends RelRule.Config {
        public static final WindowGroupReorderRuleConfig DEFAULT = ImmutableWindowGroupReorderRule.WindowGroupReorderRuleConfig.builder().build().withOperandSupplier(b0 -> b0.operand(LogicalWindow.class).inputs(b1 -> b1.operand(RelNode.class).anyInputs())).withDescription("ExchangeWindowGroupRule");

        @Override
        default public WindowGroupReorderRule toRule() {
            return new WindowGroupReorderRule(this);
        }
    }
}

