/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.datagen.source;

import java.util.Iterator;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.lib.util.IteratorSourceReaderBase;
import org.apache.flink.api.connector.source.lib.util.IteratorSourceSplit;
import org.apache.flink.connector.datagen.source.GeneratorFunction;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

@Experimental
public class GeneratingIteratorSourceReader<E, O, IterT extends Iterator<E>, SplitT extends IteratorSourceSplit<E, IterT>>
extends IteratorSourceReaderBase<E, O, IterT, SplitT> {
    private final GeneratorFunction<E, O> generatorFunction;

    public GeneratingIteratorSourceReader(SourceReaderContext context, GeneratorFunction<E, O> generatorFunction) {
        super(context);
        this.generatorFunction = (GeneratorFunction)Preconditions.checkNotNull(generatorFunction);
    }

    protected O convert(E value) {
        try {
            return this.generatorFunction.map(value);
        }
        catch (Exception e) {
            String message = String.format("A user-provided generator function threw an exception on this input: %s", value.toString());
            throw new FlinkRuntimeException(message, (Throwable)e);
        }
    }

    public void start(SourceReaderContext context) {
        try {
            this.generatorFunction.open(context);
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Failed to open the GeneratorFunction", (Throwable)e);
        }
    }

    public void close() throws Exception {
        this.generatorFunction.close();
        super.close();
    }
}

