/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.druid.java.util.common.StringEncoding;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildBufferAggregatorHelper;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchHolder;
import org.apache.druid.query.aggregation.datasketches.hll.vector.HllSketchBuildVectorProcessor;
import org.apache.druid.query.aggregation.datasketches.hll.vector.HllSketchBuildVectorProcessorFactory;
import org.apache.druid.segment.ColumnProcessors;
import org.apache.druid.segment.VectorColumnProcessorFactory;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class HllSketchBuildVectorAggregator
implements VectorAggregator {
    private final HllSketchBuildVectorProcessor processor;
    private final HllSketchBuildBufferAggregatorHelper helper;

    private HllSketchBuildVectorAggregator(HllSketchBuildVectorProcessor processor, HllSketchBuildBufferAggregatorHelper helper) {
        this.processor = processor;
        this.helper = helper;
    }

    public static HllSketchBuildVectorAggregator create(VectorColumnSelectorFactory columnSelectorFactory, String column, int lgK, TgtHllType tgtHllType, StringEncoding stringEncoding, int size) {
        HllSketchBuildBufferAggregatorHelper helper = new HllSketchBuildBufferAggregatorHelper(lgK, tgtHllType, size);
        HllSketchBuildVectorProcessor processor = (HllSketchBuildVectorProcessor)ColumnProcessors.makeVectorProcessor((String)column, (VectorColumnProcessorFactory)new HllSketchBuildVectorProcessorFactory(helper, stringEncoding), (VectorColumnSelectorFactory)columnSelectorFactory);
        return new HllSketchBuildVectorAggregator(processor, helper);
    }

    public void init(ByteBuffer buf, int position) {
        this.helper.init(buf, position);
    }

    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        this.processor.aggregate(buf, position, startRow, endRow);
    }

    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        this.processor.aggregate(buf, numRows, positions, rows, positionOffset);
    }

    public Object get(ByteBuffer buf, int position) {
        return HllSketchHolder.of(this.helper.get(buf, position));
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuf, ByteBuffer newBuf) {
        this.helper.relocate(oldPosition, newPosition, oldBuf, newBuf);
    }

    public void close() {
        this.helper.clear();
    }
}

