/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.audit;

import org.apache.druid.audit.AuditEntry;
import org.apache.druid.java.util.common.logger.Logger;

public class AuditLogger {
    private static final String MSG_FORMAT = "User[%s], identity[%s], IP[%s] performed action of type[%s] on key[%s] with comment[%s], request[%s], payload[%s].";
    private final Level level;
    private final Logger logger = new Logger(AuditLogger.class);

    public AuditLogger(Level level) {
        this.level = level;
    }

    public void log(AuditEntry entry) {
        Object[] args = new Object[]{entry.getAuditInfo().getAuthor(), entry.getAuditInfo().getIdentity(), entry.getAuditInfo().getIp(), entry.getType(), entry.getKey(), entry.getAuditInfo().getComment(), entry.getRequest(), entry.getPayload()};
        switch (this.level.ordinal()) {
            case 0: {
                this.logger.debug(MSG_FORMAT, args);
                break;
            }
            case 1: {
                this.logger.info(MSG_FORMAT, args);
                break;
            }
            case 2: {
                this.logger.warn(MSG_FORMAT, args);
            }
        }
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN;

    }
}

